/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.List;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.Gaussian98Format;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Gaussian98Reader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Gaussian98Reader.class);
    private int atomCount = 0;
    private String lastRoute = "";
    private BooleanIOSetting readOptimizedStructureOnly;

    public Gaussian98Reader() {
        this(new StringReader(""));
    }

    public Gaussian98Reader(InputStream input) {
        this(new InputStreamReader(input));
    }

    @Override
    public IResourceFormat getFormat() {
        return Gaussian98Format.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public Gaussian98Reader(Reader input) {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this.initIOSettings();
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        this.customizeJob();
        if (object instanceof IChemFile) {
            IChemFile file = (IChemFile)object;
            try {
                file = this.readChemFile(file);
            }
            catch (IOException exception) {
                throw new CDKException("Error while reading file: " + exception.toString(), exception);
            }
            return (T)file;
        }
        throw new CDKException("Reading of a " + object.getClass().getName() + " is not supported.");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException, IOException {
        IChemSequence sequence = chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel model = null;
        String line = this.input.readLine();
        int modelCounter = 0;
        while (this.input.ready() && line != null) {
            if (line.indexOf("Standard orientation:") >= 0) {
                model = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                this.readCoordinates(model);
                break;
            }
            line = this.input.readLine();
        }
        if (model != null) {
            line = this.input.readLine().trim();
            while (this.input.ready() && line != null) {
                if (line.indexOf(35) == 0) {
                    this.lastRoute = line;
                    modelCounter = 0;
                } else if (line.indexOf("Standard orientation:") >= 0) {
                    if (!this.readOptimizedStructureOnly.isSet()) {
                        sequence.addChemModel(model);
                    } else {
                        logger.info("Skipping frame, because I was told to do");
                    }
                    this.fireFrameRead();
                    model = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    ++modelCounter;
                    this.readCoordinates(model);
                } else if (line.indexOf("SCF Done:") >= 0) {
                    model.setProperty("cdk:Remark", line.trim());
                } else if (line.indexOf("Harmonic frequencies") < 0) {
                    if (line.indexOf("Total atomic charges") >= 0) {
                        this.readPartialCharges(model);
                    } else if (line.indexOf("Magnetic shielding") >= 0) {
                        this.readNMRData(model, line);
                    } else if (line.indexOf("GINC") >= 0) {
                        String levelOfTheory = this.parseLevelOfTheory(line);
                        logger.debug("Level of Theory for this model: " + levelOfTheory);
                        String description = this.lastRoute + ", model no. " + modelCounter;
                        model.setProperty("cdk:Description", description);
                    }
                }
                line = this.input.readLine();
            }
            sequence.addChemModel(model);
            this.fireFrameRead();
        }
        chemFile.addChemSequence(sequence);
        return chemFile;
    }

    private void readCoordinates(IChemModel model) throws CDKException, IOException {
        IAtomContainerSet moleculeSet = model.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainer molecule = model.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        String line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        while (this.input.ready() && (line = this.input.readLine()) != null && line.indexOf("-----") < 0) {
            int atomicNumber;
            StringReader sr = new StringReader(line);
            StreamTokenizer token = new StreamTokenizer(sr);
            token.nextToken();
            if (token.nextToken() == -2) {
                atomicNumber = (int)token.nval;
                if (atomicNumber == 0) {
                    continue;
                }
            } else {
                throw new CDKException("Error while reading coordinates: expected integer.");
            }
            token.nextToken();
            if (token.nextToken() != -2) {
                throw new IOException("Error reading x coordinate");
            }
            double x = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading y coordinate");
            }
            double y = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading z coordinate");
            }
            double z = token.nval;
            String symbol = "Du";
            symbol = PeriodicTable.getSymbol(atomicNumber);
            IAtom atom = model.getBuilder().newInstance(IAtom.class, symbol);
            atom.setPoint3d(new Point3d(x, y, z));
            molecule.addAtom(atom);
        }
        this.atomCount = molecule.getAtomCount();
        moleculeSet.addAtomContainer(molecule);
        model.setMoleculeSet(moleculeSet);
    }

    private void readPartialCharges(IChemModel model) throws CDKException, IOException {
        logger.info("Reading partial atomic charges");
        IAtomContainerSet moleculeSet = model.getMoleculeSet();
        IAtomContainer molecule = moleculeSet.getAtomContainer(0);
        String line = this.input.readLine();
        while (this.input.ready()) {
            line = this.input.readLine();
            logger.debug("Read charge block line: " + line);
            if (line == null || line.indexOf("Sum of Mulliken charges") >= 0) {
                logger.debug("End of charge block found");
                break;
            }
            StringReader sr = new StringReader(line);
            StreamTokenizer tokenizer = new StreamTokenizer(sr);
            if (tokenizer.nextToken() != -2) continue;
            int atomCounter = (int)tokenizer.nval;
            tokenizer.nextToken();
            if (tokenizer.nextToken() != -2) {
                throw new CDKException("Error while reading charge: expected double.");
            }
            double charge = tokenizer.nval;
            logger.debug("Found charge for atom " + atomCounter + ": " + charge);
            IAtom atom = molecule.getAtom(atomCounter - 1);
            atom.setCharge(charge);
        }
    }

    private void readNMRData(IChemModel model, String labelLine) throws CDKException {
        List<IAtomContainer> containers = ChemModelManipulator.getAllAtomContainers(model);
        if (containers.size() == 0) {
            return;
        }
        IAtomContainer ac = containers.get(0);
        String label = labelLine.indexOf("Diamagnetic") >= 0 ? "Diamagnetic Magnetic shielding (Isotropic)" : (labelLine.indexOf("Paramagnetic") >= 0 ? "Paramagnetic Magnetic shielding (Isotropic)" : "Magnetic shielding (Isotropic)");
        int atomIndex = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            try {
                String line = this.input.readLine().trim();
                while (line.indexOf("Isotropic") < 0) {
                    if (line == null) {
                        return;
                    }
                    line = this.input.readLine().trim();
                }
                StringTokenizer st1 = new StringTokenizer(line);
                while (st1.hasMoreTokens() && !st1.nextToken().equals("Isotropic")) {
                }
                while (st1.hasMoreTokens() && !st1.nextToken().equals("=")) {
                }
                double shielding = Double.valueOf(st1.nextToken());
                logger.info("Type of shielding: " + label);
                ac.getAtom(atomIndex).setProperty("cdk:IsotropicShielding", new Double(shielding));
                ++atomIndex;
                continue;
            }
            catch (IOException | NumberFormatException exc) {
                logger.debug("failed to read line from gaussian98 file where I expected one.");
            }
        }
    }

    private String parseLevelOfTheory(String line) {
        StringBuffer summary = new StringBuffer();
        summary.append(line);
        try {
            do {
                line = this.input.readLine().trim();
                summary.append(line);
            } while (line.indexOf(64) < 0);
        }
        catch (Exception exc) {
            logger.debug("syntax problem while parsing summary of g98 section: ");
            logger.debug(exc);
        }
        logger.debug("parseLoT(): " + summary.toString());
        StringTokenizer st1 = new StringTokenizer(summary.toString(), "\\");
        if (st1.countTokens() < 6) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            st1.nextToken();
        }
        return st1.nextToken() + "/" + st1.nextToken();
    }

    private void initIOSettings() {
        this.readOptimizedStructureOnly = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("ReadOptimizedStructureOnly", IOSetting.Importance.LOW, "Should I only read the optimized structure from a geometry optimization?", "false"));
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.readOptimizedStructureOnly);
    }
}

