/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Vector2d;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.generators.standard.VecmathUtil;

final class HydrogenPosition
extends Enum<HydrogenPosition> {
    public static final /* enum */ HydrogenPosition Right = new HydrogenPosition(0.0, new Vector2d(1.0, 0.0));
    public static final /* enum */ HydrogenPosition Left = new HydrogenPosition(Math.PI, new Vector2d(-1.0, 0.0));
    public static final /* enum */ HydrogenPosition Above = new HydrogenPosition(1.5707963267948966, new Vector2d(0.0, 1.0));
    public static final /* enum */ HydrogenPosition Below = new HydrogenPosition(4.71238898038469, new Vector2d(0.0, -1.0));
    private static final Set<Elements> PREFIXED_H;
    private static final double VERTICAL_THRESHOLD = 0.1;
    private static final double TAU = Math.PI * 2;
    private final double direction;
    private final Vector2d vector;
    private static final /* synthetic */ HydrogenPosition[] $VALUES;

    public static HydrogenPosition[] values() {
        return (HydrogenPosition[])$VALUES.clone();
    }

    public static HydrogenPosition valueOf(String name) {
        return Enum.valueOf(HydrogenPosition.class, name);
    }

    private HydrogenPosition(double direction, Vector2d vector) {
        this.direction = direction;
        this.vector = vector;
    }

    Vector2d vector() {
        return this.vector;
    }

    static HydrogenPosition position(IAtom atom, List<IAtom> neighbors) {
        List<Vector2d> vectors = VecmathUtil.newUnitVectors(atom, neighbors);
        if (neighbors.size() > 2) {
            return HydrogenPosition.usingAngularExtent(vectors);
        }
        if (neighbors.size() > 1) {
            return HydrogenPosition.usingCardinalDirection(VecmathUtil.average(vectors));
        }
        if (neighbors.size() == 1) {
            return vectors.get((int)0).x > 0.1 ? Left : Right;
        }
        return HydrogenPosition.usingDefaultPlacement(atom);
    }

    static HydrogenPosition usingAngularExtent(List<Vector2d> vectors) {
        double[] extents = VecmathUtil.extents(vectors);
        Arrays.sort(extents);
        HashMap<HydrogenPosition, OffsetExtent> extentMap = new HashMap<HydrogenPosition, OffsetExtent>();
        for (int i = 0; i < extents.length; ++i) {
            double before = extents[i];
            double d = extents[(i + 1) % extents.length];
            for (HydrogenPosition position : HydrogenPosition.values()) {
                double bias = Math.PI * 2 - position.direction;
                double afterBias = d + bias;
                double beforeBias = before + bias;
                if (beforeBias >= Math.PI * 2) {
                    beforeBias -= Math.PI * 2;
                }
                if (afterBias >= Math.PI * 2) {
                    afterBias -= Math.PI * 2;
                }
                double afterExtent = afterBias;
                double beforeExtent = Math.PI * 2 - beforeBias;
                double totalExtent = afterExtent + beforeExtent;
                double offset = Math.abs(totalExtent / 2.0 - beforeExtent);
                OffsetExtent offsetExtent = (OffsetExtent)extentMap.get((Object)position);
                if (offsetExtent != null && !(totalExtent < offsetExtent.extent)) continue;
                extentMap.put(position, new OffsetExtent(totalExtent, offset));
            }
        }
        Set extentEntries = extentMap.entrySet();
        Map.Entry<HydrogenPosition, OffsetExtent> best = null;
        for (Map.Entry<HydrogenPosition, OffsetExtent> entry : extentEntries) {
            if (best != null && ExtentPriority.INSTANCE.compare(entry, best) >= 0) continue;
            best = entry;
        }
        assert (best != null);
        return (HydrogenPosition)((Object)best.getKey());
    }

    static HydrogenPosition usingCardinalDirection(Vector2d opposite) {
        double theta = Math.atan2(opposite.y, opposite.x);
        int direction = (int)Math.round(theta / 0.7853981633974483);
        switch (direction) {
            case -4: 
            case -3: {
                return Right;
            }
            case -2: {
                return Above;
            }
            case -1: 
            case 0: 
            case 1: {
                return Left;
            }
            case 2: {
                return Below;
            }
            case 3: 
            case 4: {
                return Right;
            }
        }
        return Right;
    }

    static HydrogenPosition usingDefaultPlacement(IAtom atom) {
        if (PREFIXED_H.contains((Object)Elements.ofNumber(atom.getAtomicNumber()))) {
            return Left;
        }
        return Right;
    }

    static {
        $VALUES = new HydrogenPosition[]{Right, Left, Above, Below};
        PREFIXED_H = new HashSet<Elements>(Arrays.asList(Elements.Oxygen, Elements.Sulfur, Elements.Selenium, Elements.Tellurium, Elements.Fluorine, Elements.Chlorine, Elements.Bromine, Elements.Iodine));
    }

    private static enum ExtentPriority implements Comparator<Map.Entry<HydrogenPosition, OffsetExtent>>
    {
        INSTANCE;


        @Override
        public int compare(Map.Entry<HydrogenPosition, OffsetExtent> a, Map.Entry<HydrogenPosition, OffsetExtent> b) {
            OffsetExtent aExtent = a.getValue();
            OffsetExtent bExtent = b.getValue();
            double extentDiff = bExtent.extent - aExtent.extent;
            if (Math.abs(extentDiff) > 0.05) {
                return (int)Math.signum(extentDiff);
            }
            double offsetDiff = bExtent.offset - aExtent.offset;
            if (Math.abs(offsetDiff) > 0.05) {
                return (int)(-Math.signum(offsetDiff));
            }
            return a.getKey().compareTo((Enum)b.getKey());
        }
    }

    private static final class OffsetExtent {
        private final double extent;
        private final double offset;

        private OffsetExtent(double extent, double offset) {
            this.extent = extent;
            this.offset = offset;
        }

        public String toString() {
            return String.format("%.2f, %.2f", this.extent, this.offset);
        }
    }
}

