/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.AbstractStereo;

public class TetrahedralChirality
extends AbstractStereo<IAtom, IAtom>
implements ITetrahedralChirality {
    public TetrahedralChirality(IAtom chiralAtom, IAtom[] ligands, ITetrahedralChirality.Stereo stereo) {
        this(chiralAtom, ligands, ITetrahedralChirality.Stereo.toConfig(stereo));
    }

    public TetrahedralChirality(IAtom chiralAtom, IAtom[] ligands, int config) {
        super((IChemObject)chiralAtom, (IChemObject[])ligands, 0x4200 | 0xFF & config);
    }

    @Override
    public IAtom[] getLigands() {
        return this.getCarriers().toArray(new IAtom[4]);
    }

    @Override
    public IAtom getChiralAtom() {
        return (IAtom)this.getFocus();
    }

    @Override
    public ITetrahedralChirality.Stereo getStereo() {
        return ITetrahedralChirality.Stereo.toStereo(this.getConfigOrder());
    }

    @Override
    public void setStereo(ITetrahedralChirality.Stereo stereo) {
        this.setConfigOrder(ITetrahedralChirality.Stereo.toConfig(stereo));
    }

    @Override
    protected IStereoElement<IAtom, IAtom> create(IAtom focus, List<IAtom> carriers, int config) {
        return new TetrahedralChirality(focus, carriers.toArray(new IAtom[4]), config);
    }

    @Override
    public ITetrahedralChirality map(Map<IAtom, IAtom> atoms, Map<IBond, IBond> bonds) {
        return (ITetrahedralChirality)super.map(atoms, bonds);
    }

    public ITetrahedralChirality map(Map<IChemObject, IChemObject> chemobjs) {
        return (ITetrahedralChirality)super.map(chemobjs);
    }

    @Override
    public void setBuilder(IChemObjectBuilder builder) {
        super.setBuilder(builder);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Tetrahedral{").append(this.hashCode()).append(", ");
        builder.append((Object)this.getStereo()).append(", ");
        builder.append("c:").append(this.getChiralAtom()).append(", ");
        IAtom[] ligands = this.getLigands();
        for (int i = 0; i < ligands.length; ++i) {
            builder.append(i + 1).append(':').append(ligands[i]).append(", ");
        }
        builder.append('}');
        return builder.toString();
    }
}

