/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.result;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;

public class DoubleArrayResult
extends DoubleArrayResultType {
    private final List<Double> array;
    private static final long serialVersionUID = 2345607580017306612L;

    public DoubleArrayResult() {
        super(0);
        this.array = new ArrayList<Double>();
    }

    public DoubleArrayResult(int size) {
        super(size);
        this.array = new ArrayList<Double>(size);
    }

    public void add(double value) {
        this.array.add(value);
    }

    public double get(int index) {
        if (index >= this.array.size()) {
            return 0.0;
        }
        return this.array.get(index);
    }

    @Override
    public int length() {
        return Math.max(super.length(), this.array.size());
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            buf.append(this.get(i));
            if (i + 1 >= this.length()) continue;
            buf.append(',');
        }
        return buf.toString();
    }
}

