/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.traverse.DepthFirstIterator;

public class CycleDetector {
    Graph m_graph;

    public CycleDetector(DirectedGraph directedGraph) {
        this.m_graph = directedGraph;
    }

    public boolean detectCycles() {
        try {
            this.execute(null, null);
        }
        catch (CycleDetectedException cycleDetectedException) {
            return true;
        }
        return false;
    }

    public boolean detectCyclesContainingVertex(Object object) {
        try {
            this.execute(null, object);
        }
        catch (CycleDetectedException cycleDetectedException) {
            return true;
        }
        return false;
    }

    public Set findCycles() {
        HashSet hashSet = new HashSet();
        this.execute(hashSet, null);
        return hashSet;
    }

    public Set findCyclesContainingVertex(Object object) {
        HashSet hashSet = new HashSet();
        this.execute(hashSet, object);
        return hashSet;
    }

    private void execute(Set set, Object object) {
        ProbeIterator probeIterator = new ProbeIterator(set, object);
        while (probeIterator.hasNext()) {
            probeIterator.next();
        }
    }

    private class ProbeIterator
    extends DepthFirstIterator {
        private List m_path;
        private Set m_cycleSet;

        ProbeIterator(Set set, Object object) {
            super(CycleDetector.this.m_graph, object);
            this.m_cycleSet = set;
            this.m_path = new ArrayList();
        }

        protected void encounterVertexAgain(Object object, Edge edge) {
            int n;
            super.encounterVertexAgain(object, edge);
            if (n > -1) {
                if (this.m_cycleSet == null) {
                    throw new CycleDetectedException();
                }
                for (n = this.m_path.indexOf(object); n < this.m_path.size(); ++n) {
                    this.m_cycleSet.add(this.m_path.get(n));
                }
            }
        }

        protected Object provideNextVertex() {
            Object object = super.provideNextVertex();
            for (int i = this.m_path.size() - 1; i >= 0 && !CycleDetector.this.m_graph.containsEdge(this.m_path.get(i), object); --i) {
                this.m_path.remove(i);
            }
            this.m_path.add(object);
            return object;
        }
    }

    private static class CycleDetectedException
    extends RuntimeException {
        private static final long serialVersionUID = 3834305137802950712L;

        private CycleDetectedException() {
        }
    }
}

