/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.log4j.Logger;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Line3;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

public class Plane3
implements EuclidConstants {
    static final Logger LOG = Logger.getLogger(Plane3.class);
    protected Vector3 vect;
    protected double dist;
    double[] array = new double[4];

    public Plane3() {
        this.vect = new Vector3();
        this.dist = 0.0;
    }

    public Plane3(double l, double m, double n, double d) throws EuclidRuntimeException {
        this.vect = new Vector3(l, m, n);
        if (this.vect.isZero()) {
            throw new EuclidRuntimeException("zero length normal");
        }
        this.dist = d;
        this.vect.normalize();
    }

    public Plane3(double[] lmn, double d) throws EuclidRuntimeException {
        Util.check(lmn, 3);
        this.vect = new Vector3(lmn);
        this.dist = d;
        this.vect.normalize();
    }

    public Plane3(double[] array) throws EuclidRuntimeException {
        Util.check(array, 4);
        this.vect = new Vector3();
        System.arraycopy(array, 0, this.vect.flarray, 0, 3);
        this.dist = array[3];
        System.arraycopy(array, 0, this.array, 0, 4);
    }

    public Plane3(Vector3 v, double d) throws EuclidRuntimeException {
        if (v.isZero()) {
            throw new EuclidRuntimeException("zero length normal");
        }
        this.vect = new Vector3(v);
        this.dist = d;
        this.vect.normalize();
    }

    public Plane3(Plane3 pl) {
        this.vect = new Vector3(pl.vect);
        this.dist = pl.dist;
    }

    public Plane3(Point3 p1, Point3 p2, Point3 p3) throws EuclidRuntimeException {
        this.vect = new Vector3();
        this.dist = 0.0;
        this.vect = p2.subtract(p1).cross(p3.subtract(p2));
        if (this.vect.isZero()) {
            throw new EuclidRuntimeException("zero length normal");
        }
        this.vect.normalize();
        Vector3 vp1 = new Vector3(p1);
        this.dist = vp1.dot(this.vect);
    }

    public Plane3(Line3 l, Point3 p) throws EuclidRuntimeException {
        this(l.getPoint(), l.getPoint().plus(l.getVector()), p);
    }

    public double[] getArray() {
        System.arraycopy(this.vect.flarray, 0, this.array, 0, 3);
        this.array[3] = this.dist;
        return this.array;
    }

    public Vector3 getVector() {
        return this.vect;
    }

    public double getDistance() {
        return this.dist;
    }

    public void negative() {
        this.vect.negativeEquals();
    }

    public boolean isEqualTo(Plane3 pl2) {
        if (!this.vect.isEqualTo(pl2.vect)) {
            return false;
        }
        return Real.isEqual(pl2.dist, this.dist);
    }

    public Plane3 subtract() {
        Plane3 pl = this;
        pl.vect = pl.vect.negative();
        return pl;
    }

    public double getDistanceFromPoint(Point3 p) {
        Vector3 v = new Vector3(p);
        return v.dot(this.vect) - this.dist;
    }

    public boolean isParallelTo(Plane3 pl2) {
        return this.vect.isIdenticalTo(pl2.vect);
    }

    public boolean isAntiparallelTo(Plane3 pl2) {
        Vector3 v = new Vector3(pl2.vect);
        return this.vect.isIdenticalTo(v.negative());
    }

    public boolean containsPoint(Point3 p) {
        return Real.isZero(this.getDistanceFromPoint(p), Real.getEpsilon());
    }

    public Point3 getClosestPointTo(Point3 p2) {
        Point3 p1 = new Point3();
        double d = this.getDistanceFromPoint(p2);
        Vector3 v = new Vector3(this.vect.multiplyBy(d));
        Vector3 vv = new Vector3(p2);
        p1 = new Point3(vv.subtract(v));
        return p1;
    }

    public Point3 getIntersectionWith(Line3 l) {
        Point3 p = null;
        Vector3 v = new Vector3(l.getPoint());
        Vector3 lvect = new Vector3(l.getVector());
        double numer = this.dist - this.vect.dot(v);
        double denom = this.vect.dot(lvect);
        if (!Real.isZero(denom, Real.getEpsilon())) {
            double lambda = numer / denom;
            p = l.getPoint().plus(lvect.multiplyBy(lambda));
        }
        return p;
    }

    public Line3 getIntersectionWith(Plane3 pl2) {
        Vector3 v3 = this.vect.cross(pl2.vect);
        v3.normalize();
        Point3 p = new Point3(this.vect.multiplyBy(this.dist));
        Vector3 v1a = this.vect.cross(v3);
        Line3 l1 = new Line3(p, v1a);
        Point3 p2 = pl2.getIntersectionWith(l1);
        return p2 == null ? null : new Line3(p2, v3);
    }

    public Point3 getIntersectionWith(Plane3 pl2, Plane3 pl3) {
        Point3 p = new Point3();
        Line3 l = pl2.getIntersectionWith(pl3);
        p = this.getIntersectionWith(l);
        return p;
    }

    public Angle getAngleMadeWith(Plane3 pl2) {
        return this.getVector().getAngleMadeWith(pl2.getVector());
    }

    public String toString() {
        return "(" + this.vect + "," + this.dist + ")";
    }
}

