/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import io.github.dan2097.jnainchi.InchiFlag;
import io.github.dan2097.jnainchi.InchiStatus;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.INCHI_RET;

final class JniInchiSupport {
    private JniInchiSupport() {
    }

    static INCHI_RET toJniStatus(InchiStatus status) {
        switch (status) {
            case SUCCESS: {
                return INCHI_RET.OKAY;
            }
            case WARNING: {
                return INCHI_RET.WARNING;
            }
            case ERROR: {
                return INCHI_RET.ERROR;
            }
        }
        throw new IllegalArgumentException("Unexpected status!");
    }

    static InchiFlag toJnaOption(INCHI_OPTION flag) {
        switch (flag) {
            case SUCF: {
                return InchiFlag.SUCF;
            }
            case ChiralFlagON: {
                return InchiFlag.ChiralFlagON;
            }
            case ChiralFlagOFF: {
                return InchiFlag.ChiralFlagOFF;
            }
            case SNon: {
                return InchiFlag.SNon;
            }
            case SRel: {
                return InchiFlag.SRel;
            }
            case SRac: {
                return InchiFlag.SRac;
            }
            case SUU: {
                return InchiFlag.SUU;
            }
            case RecMet: {
                return InchiFlag.RecMet;
            }
            case FixedH: {
                return InchiFlag.FixedH;
            }
            case AuxNone: {
                return InchiFlag.AuxNone;
            }
            case DoNotAddH: {
                return InchiFlag.DoNotAddH;
            }
            case WarnOnEmptyStructure: {
                return InchiFlag.WarnOnEmptyStructure;
            }
        }
        System.err.println("Unsupported flag: " + flag);
        return null;
    }
}

