% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rcicr.R
\name{computeCumulativeCICorrelation}
\alias{computeCumulativeCICorrelation}
\title{Computes cumulative trial CIs correlations with final/target CI}
\usage{
computeCumulativeCICorrelation(stimuli, responses, baseimage, rdata,
  targetci = list(), step = 1)
}
\arguments{
\item{stimuli}{Vector with stimulus numbers (should be numeric) that were presented in the order of the response vector. Stimulus numbers must match those in file name of the generated stimuli}

\item{responses}{Vector specifying the responses in the same order of the stimuli vector, coded 1 for original stimulus selected and -1 for inverted stimulus selected.}

\item{baseimage}{String specifying which base image was used. Not the file name, but the key used in the list of base images at time of generating the stimuli.}

\item{rdata}{String pointing to .RData file that was created when stimuli were generated. This file contains the contrast parameters of all generated stimuli.}

\item{targetci}{List Target CI object generated with rcicr functions to correlate cumulative CIs with}

\item{step}{Step size in sequence of trials to compute correlations with}
}
\value{
Vector containing correlation between cumulative CI and final/target CI
}
\description{
Computes cumulative trial CIs correlations with final/target CI.
}
\details{
Use for instance for plotting curves of trial-final/target CI correlations to estimate how many trials are necessary in your task
}

