% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climate_data.R
\name{ec_climate_data}
\alias{ec_climate_data}
\alias{ec_climate_mudata}
\title{Load Environment Canada Historical Climate Data}
\usage{
ec_climate_data(location, timeframe = c("monthly", "daily", "hourly"),
  start = NA, end = NA, value_parser = readr::parse_double,
  cache = get_default_cache(), quiet = TRUE)

ec_climate_mudata(location, timeframe = c("monthly", "daily", "hourly"),
  start = NA, end = NA, cache = get_default_cache(), quiet = TRUE)
}
\arguments{
\item{location}{A vector of unambiguous name identifiers or station IDs
(resolved using \link{as_ec_climate_location}).}

\item{timeframe}{One of monthly, daily, or hourly.}

\item{start}{The first date to be included in the output as a Date object
or in YYYY-MM-DD format (passed through \link{as.Date})}

\item{end}{The last date to be included in the output as a Date object
or in YYYY-MM-DD format (passed through \link{as.Date})}

\item{value_parser}{A readr parse function (like
\link[readr:parse_double]{parse_double} or \link[readr:parse_character]{parse_character}) to apply
to value columns. The default is to use \link[readr:parse_double]{parse_double}, but
occasionally values are in the form ">30", or "<30", especially for wind speed.
When this happens a warning will occur, and \link[readr:problems]{problems}() can be used
to see which values were dropped. Use \link[readr:parse_character]{parse_character}) to skip parsing
and extract the values yourself.}

\item{cache}{A directory in which to cache downloaded files}

\item{quiet}{Use FALSE for verbose output}
}
\value{
A data.frame (tibble) with an attribute "flag_info", containing the flag information.
\code{ec_climate_mudata()} returns a \link[mudata2:mudata]{mudata} object.
}
\description{
Load Environment Canada Historical Climate Data
}
\examples{
\donttest{
# station 27141 is Kentville CDA CS
monthly <- ec_climate_data(27141, timeframe = "monthly")
daily <- ec_climate_data(27141, timeframe = "daily", start = "1999-01-01", end = "1999-12-31")
hourly <- ec_climate_data(27141, timeframe = "hourly", start = "1999-07-01", end = "1999-07-31")

# get climate data in mudata format
library(mudata2)
monthly_md <- ec_climate_mudata(27141, timeframe = "monthly")
daily_md <- ec_climate_mudata(27141, timeframe = "daily",
                              start = "1999-01-01", end = "1999-12-31")
hourly_md <- ec_climate_mudata(27141, timeframe = "hourly",
                               start = "1999-07-01", end = "1999-07-31")

# mudata objects can easily be plotted
autoplot(monthly_md)
autoplot(daily_md)
autoplot(hourly_md)
}

}
\references{
\url{http://climate.weather.gc.ca/historical_data/search_historic_data_e.html}
\url{ftp://client_climate@ftp.tor.ec.gc.ca/Pub/Get_More_Data_Plus_de_donnees/Readme.txt}
\url{http://climate.weather.gc.ca/glossary_e.html}
}
