% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climate_data.R
\name{ec_climate_data_base}
\alias{ec_climate_data_base}
\title{Low-level access to the EC Climate Bulk Data Service}
\usage{
ec_climate_data_base(location, timeframe = c("monthly", "daily",
  "hourly"), year = NULL, month = NULL, cache = NULL,
  quiet = FALSE, check_dates = FALSE,
  endpoint = "http://climate.weather.gc.ca/climate_data/bulk_data_e.html")
}
\arguments{
\item{location}{A vector of unambiguous name identifiers or station IDs
(resolved using \link{as_ec_climate_location}).}

\item{timeframe}{One of monthly, daily, or hourly.}

\item{year}{The year for which to get data (required for daily requests)}

\item{month}{The month for which to get data (required for hourly requests)}

\item{cache}{A directory in which to cache downloaded files}

\item{quiet}{Use FALSE for verbose output}

\item{check_dates}{Check the request data against \link{ec_climate_locations_all}
to avoid downloading data that is known not to exist. Pass FALSE to circumvent
this check.}

\item{endpoint}{The web address for the EC data service}
}
\value{
A data.frame (tibble) of the downloaded data frame, with all columns as
character vectors
}
\description{
Low-level access to the EC Climate Bulk Data Service
}
\examples{
\donttest{
# station 27141 is Kentville CDA CS
monthly <- ec_climate_data_base(27141, timeframe = "monthly")
daily <- ec_climate_data_base(27141, timeframe = "daily", year = 1999)
hourly <- ec_climate_data_base(27141, timeframe = "hourly", year = 1999, month = 7)
}

}
\references{
\url{http://climate.weather.gc.ca/historical_data/search_historic_data_e.html}
\url{ftp://client_climate@ftp.tor.ec.gc.ca/Pub/Get_More_Data_Plus_de_donnees/Readme.txt}
}
