% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_study_xml.R
\name{parse_study_xml}
\alias{parse_study_xml}
\title{Parses study information for a trial downloaded from
clinicaltrials.gov}
\usage{
parse_study_xml(file, include_textblocks = FALSE, include_results = FALSE)
}
\arguments{
\item{file}{Path to xml file}

\item{include_textblocks}{Logical, include long textblock fields in the
results}

\item{include_results}{Logical, include results data, if available}
}
\value{
A list of \code{data.frame}s, study information, locations,
  interventions, arms, outcomes, results, and textblocks. Results and textblock
  frames will be \code{NULL} if not requested.
}
\description{
Results of a clinical study are stored in a particular way. This reads and
organizes the from a trial xml file (stored in a temporary directory)
and returns it as a list of dataframes. Optionally includes long textblock
fields and results fields stored as separate data frames.
}
\keyword{Internal}

