% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_nu_search.R
\name{cp_nu_search}
\alias{cp_nu_search}
\title{Name Usage: Search}
\usage{
cp_nu_search(
  q = NULL,
  dataset_key = NULL,
  min_rank = NULL,
  max_rank = NULL,
  content = NULL,
  highlight = NULL,
  reverse = NULL,
  fuzzy = NULL,
  type = NULL,
  nomstatus = NULL,
  status = NULL,
  issue = NULL,
  published_in = NULL,
  facet = NULL,
  sortBy = NULL,
  start = 0,
  limit = 10,
  ...
)
}
\arguments{
\item{q}{(character) vector of one or more scientific names}

\item{dataset_key}{(character) dataset key}

\item{min_rank, max_rank}{(character) filter by rank. one of: domain, superkingdom,
kingdom, subkingdom, infrakingdom, superphylum, phylum, subphylum,
infraphylum, superclass, class, subclass, infraclass, parvclass,
superlegion, legion, sublegion, infralegion, supercohort, cohort,
subcohort, infracohort, magnorder, superorder, grandorder, order,
suborder, infraorder, parvorder, superfamily, family, subfamily,
infrafamily, supertribe, tribe, subtribe, infratribe, suprageneric name,
genus, subgenus, infragenus, supersection, section, subsection, superseries,
series, subseries, infrageneric name, species aggregate, species,
infraspecific name, grex, subspecies, cultivar group, convariety,
infrasubspecific name, proles, natio, aberration, morph, variety,
subvariety, form, subform, pathovar, biovar, chemovar, morphovar, phagovar,
serovar, chemoform, forma specialis, cultivar, strain, other, unranked}

\item{content}{(character) one of: 'scientific_name' or 'authorship'}

\item{highlight}{(logical) \code{TRUE} or \code{FALSE}. default: \code{NULL}}

\item{reverse}{(logical) \code{TRUE} or \code{FALSE}. default: \code{NULL}}

\item{fuzzy}{(logical) \code{TRUE} or \code{FALSE}. default: \code{NULL}}

\item{type}{(character) one of: 'prefix', 'whole_words', 'exact'}

\item{nomstatus}{(character) filter by nomenclatural status. one of: ok,
unavailable, illegitimate, variant, conserved, rejected, doubtful, unevaluated}

\item{status}{(character) filter by taxonomic status. one of: accepted,
doubtful, ambiguous synonym}

\item{issue}{(character) filter by issue found}

\item{published_in}{(character) reference id to filter names by}

\item{facet}{(character) request a facet to be returned. one of:
dataset_key, rank, nom_status, status, issue, type, field. facet
limit default: 50}

\item{sortBy}{(character) one of: "relevance", "name", "taxonomic",
"index_name_id", or "native"}

\item{start}{(integer) requested number of offset records. Default: 0}

\item{limit}{(integer) requested number of maximum records to be returned.
Default: 10; max: 1000}

\item{...}{curl options passed on to \code{\link[crul]{verb-GET}}}
}
\value{
list with two slots
\itemize{
\item \code{result} (data.frame/tibble): results, a zero row data.frame
if no results found
\item \code{meta} (data.frame/tibble): number of results found
}
}
\description{
Name Usage: Search
}
\examples{
if (cp_up("/nameusage/search?q=Apis")) {
cp_nu_search(q="Apis", limit = 1)
}
\dontrun{
cp_nu_search(q="Agapostemon")
cp_nu_search(q="Agapostemon", dataset_key = 3)
cp_nu_search(q="Agapostemon", min_rank = "genus")
cp_nu_search(q="Agapostemon", nomstatus = "doubtful")
cp_nu_search(q="Agapostemon", status = "accepted")
cp_nu_search(q="Bombus", facet = "rank")
cp_nu_search(q="Agapostemon", dataset_key = 3, hasField="uninomial")

x <- cp_nu_search(q="Poa")
x
x$result
x$result$usage
x$result$usage$name
}
}
