% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freemanTheta.r
\name{freemanTheta}
\alias{freemanTheta}
\title{Freeman's theta}
\usage{
freemanTheta(x, g = NULL, group = "row", verbose = FALSE,
  progress = FALSE, digits = 3)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations of an ordinal variable.}

\item{g}{If \code{x} is a vector, \code{g} is the vector of observations for
the grouping, nominal variable.}

\item{group}{If \code{x} is a table or matrix, \code{group} indicates whether
the \code{"row"} or the \code{"column"} variable is
the nominal, grouping variable.}

\item{verbose}{If \code{TRUE}, prints statistics for each
comparison.}

\item{progress}{If \code{TRUE}, prints a message as each comparison is
conducted.}

\item{digits}{The number of significant digits in the output.}
}
\value{
A single statistic, Freeman's theta
}
\description{
Calculates Freeman's theta for a table with one ordinal
             variable and one nominal variable.
}
\details{
Freeman's coefficent of differentiation (theta)
          is used as a measure of association
          for a two-way
          table with one ordinal and one nominal variable.
          See Freeman (1965).
          
          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
}
\examples{
data(Breakfast)
library(coin)
chisq_test(Breakfast, scores = list("Breakfast" = c(-2, -1, 0, 1, 2)))
freemanTheta(Breakfast)

### Example from Freeman (1965), Table 10.6
Counts = c(1,2,5,2,0,10,5,5,0,0,0,0,2,2,1,0,0,0,2,3)
Matrix = matrix(Counts, byrow=TRUE, ncol=5,
               dimnames = list(Marital.status=c("Single","Married","Widowed",
                                                "Divorced"),
                               Social.adjustment = c("5","4","3","2","1")))
Matrix
freemanTheta(Matrix)

### Example after Kruskal Wallis test
data(PoohPiglet)
kruskal.test(Likert ~ Speaker, data = PoohPiglet)
freemanTheta(x = PoohPiglet$Likert, g = PoohPiglet$Speaker)

### Same data, as table of counts
data(PoohPiglet)
XT = xtabs( ~ Speaker + Likert , data = PoohPiglet)
freemanTheta(XT)

}
\references{
Freeman, L.C. 1965. Elementary Applied Statistics for Students
            in Behavioral Science. Wiley.

            \url{http://rcompanion.org/handbook/H_11.html}
}
\seealso{
\code{\link{epsilonSquared}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{correlation Freeman theta ordinal nominal}
