% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epsilonSquared.r
\name{epsilonSquared}
\alias{epsilonSquared}
\title{Epsilon-squared}
\usage{
epsilonSquared(x, g = NULL, group = "row", ci = FALSE, conf = 0.95,
  type = "perc", R = 1000, histogram = FALSE, digits = 3, ...)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations of an ordinal variable.}

\item{g}{If \code{x} is a vector, \code{g} is the vector of observations for
the grouping, nominal variable.}

\item{group}{If \code{x} is a table or matrix, \code{group} indicates whether
the \code{"row"} or the \code{"column"} variable is
the nominal, grouping variable.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{kruskal.test} function.}
}
\value{
A single statistic, epsilon-squared.
        Or a small data frame consisting of epsilon-squared,
        and the lower and upper confidence limits.
}
\description{
Calculates epsilon-squared for a table with one ordinal
             variable and one nominal variable; confidence intervals
             by bootstrap.
}
\details{
Epsilon-squared is used as a measure of association
          for the Kruskal-Wallis test or for a two-way
          table with one ordinal and one nominal variable.

          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
          
          Because epsilon-squared is always positive, the confidence interval will
          never cross zero. The confidence interval range should not
          be used for statistical inference. 
          
          When epsilon-squared is close to 0 or very large,
          or with small counts in some cells,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
data(Breakfast)
library(coin)
chisq_test(Breakfast, scores = list("Breakfast" = c(-2, -1, 0, 1, 2)))
epsilonSquared(Breakfast)

data(PoohPiglet)
kruskal.test(Likert ~ Speaker, data = PoohPiglet)
epsilonSquared(x = PoohPiglet$Likert, g = PoohPiglet$Speaker)

### Same data, as matrix of counts
data(PoohPiglet)
XT = xtabs( ~ Speaker + Likert , data = PoohPiglet)
epsilonSquared(XT)

}
\references{
\url{http://rcompanion.org/handbook/H_11.html}
}
\seealso{
\code{\link{freemanTheta}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{correlation epsilon ordinal nominal}
