% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxonOR.r
\name{wilcoxonOR}
\alias{wilcoxonOR}
\title{Agresti's Generalized Odds Ratio for Stochastic Dominance}
\usage{
wilcoxonOR(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  reportIncomplete = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the response variable and
the independent variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the response variable for one group.}

\item{y}{The response variable for the other group.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{reportIncomplete}{If \code{FALSE} (the default),
\code{NA} will be reported in cases where there
are instances of the calculation of the statistic
failing during the bootstrap procedure.}

\item{verbose}{If \code{TRUE}, reports the proportion of ties and
the proportions of (Ya > Yb) and (Ya < Yb).}

\item{...}{Additional arguments, not used.}
}
\value{
A single statistic, OR.
        Or a small data frame consisting of OR,
        and the lower and upper confidence limits.
}
\description{
Calculates Agresti's Generalized Odds Ratio 
 for Stochastic Dominance
 (OR) with confidence intervals by bootstrap
}
\details{
OR is an effect size statistic appropriate
         in cases where a Wilcoxon-Mann-Whitney test might be used.
         
         OR is defined as P(Ya > Yb) / P(Ya < Yb).
         
         OR can range from 0 to infinity. An OR of 1 indicates stochastic 
         equality between the two groups. An OR greater than 1 indicates
         that the first group dominates the second group.
         An OR less than 1 indicates
         that the second group dominates the first.
         
         Be cautious with this interpretation, as R will alphabetize
         groups in the formula interface if the grouping variable
         is not already a factor.
           
         The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{y}. If there are more than two groups,
         only the first two groups are used.
         
         Currently, the function makes no provisions for \code{NA}
         values in the data.  It is recommended that \code{NA}s be removed
         beforehand.

         With a small sample size, or with an OR near its extremes,
         the confidence intervals 
         determined by this
         method may not be reliable, or the procedure may fail.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(Catbus)
wilcoxonOR(Steps ~ Sex, data=Catbus, verbose=TRUE)

}
\references{
Grissom, R.J. and J.J. Kim. 2012. Effect Sizes for Research.
            2nd ed. Routledge, New York.
            
            \url{http://rcompanion.org/handbook/F_04.html}
}
\seealso{
\code{\link{wilcoxonPS}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{effect size}
