% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiMangiaficoD.r
\name{multiMangiaficoD}
\alias{multiMangiaficoD}
\title{Mangiafico's d}
\usage{
multiMangiaficoD(
  formula = NULL,
  data = NULL,
  x = NULL,
  g = NULL,
  digits = 3,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the response variable and
the independent variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the response variable.}

\item{g}{If no formula is given, the grouping variable.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{mad()} function.}
}
\value{
A list containing a data frame of pairwise statistics,
        and the comparison with the most extreme value
        of the statistic.
}
\description{
Calculates Mangiafico's d,
             which is the difference in medians
             divided by the pooled median absolute deviation,
             for several groups in a pairwise manner.
}
\details{
Mangiafico's d is an appropriate effect size statistic where
         Mood's median test, or another test comparing two medians,
         might be used.  Note that the response variable is treated
         as at least interval.
         
         When the data in the first group are greater than
         in the second group, d is positive.
         When the data in the second group are greater than
         in the first group, d is negative.
         
         Be cautious with this interpretation, as R will alphabetize
         groups in the formula interface if the grouping variable
         is not already a factor.
         
         Currently, the function makes no provisions for \code{NA}
         values in the data.  It is recommended that \code{NA}s be removed
         beforehand.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.

The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(Catbus)
multiMangiaficoD(Steps ~ Teacher, data=Catbus)

}
\references{
\url{http://rcompanion.org/handbook/F_09.html}
}
\seealso{
\code{\link{mangiaficoD}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Mangiafico's d}
\concept{confidence interval}
\concept{effect size}
