% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_minimal_r_version.R
\name{get_minimal_r_version}
\alias{get_minimal_r_version}
\title{Get required minimal R version}
\usage{
get_minimal_r_version(pkg = NULL)
}
\arguments{
\item{pkg}{a character of length 1

The name of a CRAN package or \code{NULL} (default). If \code{NULL} get minimal
required R version of the local (uninstalled) project (package or
compendium).}
}
\value{
A character with the minimal required R version.
}
\description{
This function detects the minimal required R version for the project based
on minimal required R version of its dependencies. It can be used to update
the \code{Depends} field of the \code{DESCRIPTION} file.
}
\examples{
\dontrun{
## Update dependencies ----
add_dependencies()

## Minimal R version of a project ----
get_minimal_r_version()

## Minimal R version of a CRAN package ----
get_minimal_r_version("usethis")
}
}
\seealso{
Other utilities functions: 
\code{\link{get_all_dependencies}()},
\code{\link{get_all_functions}()},
\code{\link{get_licenses}()}
}
\concept{utilities functions}
