
/* 	$Id: coeffs_swohybrid.c 861 2012-02-22 21:25:32Z hamannj $	 */

/* #ifndef lint */
/* static char vcid[] = "$Id: coeffs_swohybrid.c 861 2012-02-22 21:25:32Z hamannj $"; */
/* #endif /\* lint *\/ */

#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "conifers.h"

/*
## Coefficients
## parameter  for DF
          1st fit    refit 9/11
      a0  -1.79173   -1.98227
      a1   0.041419  +0.028342
      a2   0.736826  +0.728557
      a3  -0.02037   -0.0191611
      a4   0.533997  +0.518667
      a5  -0.17748   -0.18713
      a6  -0.16519   -0.24237
      a7             -0.05724
      a8   0.014363  +0.191632
      a9   0.230168  +0.095203
      a10             1.5
      b0  -2.41693   -2.11965
      b1   0.549293  +0.562902  
      b2   0.5656    +0.553525
      b3  -0.14752   -0.14599
      b4  -0.84549   -0.83371
      b5  -0.73261   -0.79792
      b6   0.176963  +0.50

      c0   0.836485   +0.858726
      c1   0.944264   +0.975513
      c2  -0.15986    -0.16969
*/
/*
## parameter for  PP

      a0  -2.35891    -1.28565
      a1   0.009329   0.009225
      a2   0.390781   0.375077
      a3  -0.00499    -0.000447
      a4   0.113853   0.10653
      a5  -0.39316    -0.39919
      a6  -0.28375    -0.27956
                      -0.61644
      a8   0.005282   0.003488
      a9   1.161755   0.166248
      a10             2.0
      b0  -3.14377    -2.24132
      b1   0.077142   0.109386
      b2   0.922795   0.909006
      b3  -0.16043    -0.16128
      b4  -0.83028    -0.82181
      b5  -1.17279    -1.28309
      b6   0.551608   0.50

	  c0   0.627412   0.640411
      c1   1.808261   1.866254
      c2  -0.13616    -0.14226
*/

/* The index values in the arrays below that go from 1 to N_SWOHYBRID_CONIFERS_COEFFS   */
/* MUST match up with the values in the species_variant.txt file                       */
/* This match will vary between variants thus each variant species.txt file must be    */
/* created so as to conform to the corresponding coeffs_variant.c file                 */


/* todo: add/update version number for your model's coefficients  */
#define N_SWOHYBRID_CONIFERS_COEFFS     12
#define SWOHYBRID_COEFFS_VERSION      1.00
#define SWOHYBRID_MODEL_VERSION       1.00


/* this structure MUST be the EXACT same structure def as the one defined in the header file */
struct CON_SWOHYBRID_COEFFS_RECORD 
   {
    unsigned long   idx;        /* this is the functional species code -- group in 3.0 */
    unsigned long   type;       /* 0, 1, 2, 3 or 4 */

	/* this is required for the user interface */
	 char    group[SP_LENGTH];               /*  name abbreviated from the usfs  */

	 double  d6_growth[MAX_COEFFS];          /* 1  D1: growth coeffs                */
	 double  ht_growth[MAX_COEFFS];          /* 2  D3: growth coeffs                */ 
	 double  cr_growth[MAX_COEFFS];          /* 3  D4: hcb change parameters        */
	 double  crown_ratio[MAX_COEFFS];        /* 4  S3: crown ratio coeffs           */
	 double  crown_width[MAX_COEFFS];        /* 5  S1: crown width coeffs, old CA   */
	 double  max_crown_width[MAX_COEFFS];    /* 6  S2: crown width coeffs, old CA   */
	 double  d6_ht_dbh[MAX_COEFFS];          /* 7  S5, S7                           */
	 double  d6_ht[MAX_COEFFS];              /* 8  S4, S9                           */
	 double  dbh_ht[MAX_COEFFS];             /* 9  S6, S10                          */
	 double  n_stems_from_ht[MAX_COEFFS];    /* 10 S11                              */
	 double  dbh_growth[MAX_COEFFS];         /* 11 D5: dbh growth coefficients      */
	 double  cfvolume4[MAX_COEFFS];          /* 12 S12 volume coefficients          */
	 double  biomass[MAX_COEFFS];            /* 13 S13 biomass coefficients         */
	 double  cw_growth[MAX_COEFFS];          /* 14 D6: cw_growth coefficients       */

	 /* coefficients added for the CIPS variant */
	 /* todo: you need to added these the old models too */
	 double			dbh_ht_veg_cov[MAX_COEFFS];	
	 double			d6_ht_veg_cov[MAX_COEFFS];	
	 double			d12_ht_veg_cov[MAX_COEFFS];
     double         mortality[MAX_COEFFS];         /* put in here for the tree mortality eq */


} static swo_hybrid_temp_coeffs[N_SWOHYBRID_CONIFERS_COEFFS] = {

/*   0         1         2          3         4         5         6        7         8          9         10        11       12       13        14       15        */
{ /* index 0, FBR type = 2 , this is the default for brush */
0, SHRUB, "FBR",

/* d6_growth        */{ 0.052777, 0.046057,      0.0, 0.091103, 0.004174,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{ 0.376316,-3.461019, 1.677419,-0.099159,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cr_growth        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 0.702099, 0.617866, 1.325870,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-0.958757, 0.536006,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{ 0.528185, 0.891697,-0.067543,-0.121772,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{ -6.90990, 2.854200, 0.078000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cw_growth        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.100000, 0.949400,-0.562100,-1.101110,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},

},


/*   0          1         2         3        4         5         6          7          8        9         10         11       12        13       14        15      */
{ /* index 1, FDF type = 0 */
1, CONIFER, "FDF",
/* d6_growth        */{ -2.11965,  0.562902, 0.553525, -0.14599, -0.83371, -0.79792,   0.5000,     0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,       0.0,      0.0},
/* ht_growth        */{ -1.98227,  0.028342, 0.728557, -0.01916, 0.518667, -0.18713, -0.05724, -0.24237, 0.191632, 0.095203,      1.5,  -0.2326, -0.18394,      0.0,      0.0,      0.0},
/* cr_growth        */{ 0.170720,  0.080100, 0.259900, 0.319770, 0.085170, 3.465700,-1.787900,-0.696800,-0.644600,-0.644600,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{ 0.794925,  0.984621,      0.0, 0.485596,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 0.335198,  0.494185, 1.227520,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{ 4.636600,  1.607800,-0.009625,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{ 0.778122,  0.666671, 0.174612,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-1.375748,  1.016819,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{ 7.127600, -5.364200,-0.261749,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{     0.00,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{ 0.853812,       0.0,-0.313923,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{ 0.002244,  1.943420, 0.996400, 0.999200,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,-2.846200, 1.700900,-3.694100,  2.13820, -3.03960, 2.595100,      0.0,      0.0,      0.0,      0.0},
/* cw_growth        */{ 0.858726,  0.975513, -0.16969,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0}
},


/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15   */
{ /* index 2, FPP type = 0 */
2, CONIFER, "FPP",
/* d6_growth        */{ -3.14377, 0.077142, 0.922795, -0.16043, -0.83028, -1.17279, 0.551608,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{-1.285650,  0.009225, 0.375077,-0.000447,  0.10653, -0.39919, -0.27956, -0.61644, 0.003488, 0.166248,      2.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cr_growth        */{ 0.351351,  0.105800, 0.725620,      0.0, 0.309350, 2.865400,-1.425800,-3.017700,-1.716000,-1.145200,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{ 0.857195,  0.950446,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 0.243019,  0.523308, 0.744742,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{ 3.483500,  1.343000,-0.008254,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{ 0.782144,  0.620201, 0.212225,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-0.604431,  0.884816,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{ 8.186460, -6.653220,-0.203531,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{     0.00,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{ 0.860776,       0.0,-0.296480,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{ 0.002525,  1.851800, 1.000400, 1.007900,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{     0.00,      0.00,      0.0,-5.255200, 2.511800, 0.047000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cw_growth        */{ 0.640411, 1.866254, -0.14226,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0}
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15    */
{ /* index 3, FHW type = 1 */
3, HARDWOOD, "FHW",
/* d6_growth        */{-1.576230,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{-2.559060,  0.034321,      0.0, 1.281572,-0.012880,      0.0,-0.278670,      0.0,      0.0, 0.415000,-0.400000,-0.400000, 0.071864,      0.0,      0.0,      0.0},
/* cr_growth        */{ 0.314924,  0.155572,      0.0,      0.0,      0.0, 6.049900,-4.864300,-1.264200,-2.193800,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{ 0.698931,       1.0, 0.623570,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 0.940452,  0.507503, 1.093544,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{ 4.444300,  1.704000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{ 0.757731,  0.674815, 0.219771,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-1.252449,  0.820175,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{ 6.394860, -4.522690,-0.235301,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{ 0.206178,  0.910631,-0.038421,-0.254271,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{ 0.846010,       0.0,-0.923390,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{ 0.005887,  1.941650, 0.865620, 1.000000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,-3.278000,-0.019000,      0.0,      0.0},
/* cw_growth        */{ 0.880678,  1.030668,-0.122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15    */
{ /* index 4, FTO type = 1 */
4, HARDWOOD, "FTO",
/* d6_growth        */{-1.911680,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{-2.559060,  0.034321,      0.0, 1.281572,-0.012880,      0.0,-0.278670,      0.0,      0.0,  0.41500,-0.400000,-0.400000, 0.071864,      0.0,      0.0,      0.0},
/* cr_growth        */{ 0.297760,  0.087780,      0.0, 0.469220,      0.0, 6.874500,-5.240300,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{ 0.698931,       1.0, 0.623570,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 0.940452,  0.507503, 1.093544,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{ 4.444300,  1.704000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{ 0.757731,  0.674815, 0.219771,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-1.252449,  0.820175,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{ 6.394860, -4.522690,-0.235301,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{ 0.226985,  0.551898,-0.022798,-0.085937,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{ 0.846010,       0.0,-0.923390,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{ 0.005887,  1.941650, 0.865620,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 3.278000,-0.019000,      0.0,      0.0},
/* cw_growth        */{ 0.880678,  1.030668,-0.122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15  */
{ /* index 5, FGC type = 1 */
5, HARDWOOD, "FGC",
/* d6_growth        */{-1.502670,  1.009852, 0.143539,-0.082500,-0.970760,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{-1.873080,  0.034321,      0.0, 0.776911,-0.012880,      0.0,-0.278670,      0.0,      0.0, 0.415000,-0.400000,-0.400000, 0.071864,      0.0,      0.0,      0.0},
/* cr_growth        */{ 0.129790,  0.109710,      0.0,      0.0, 1.369050, 4.405700,-0.160000,-3.070400,-2.858400,-2.858400,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{ 0.766406,       1.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{-0.088500,  0.534001, 1.742941,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{ 2.979400,  1.551200,-0.014161,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{ 0.847383,  0.791405, 0.236346,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-1.321091,  1.028420,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{14.192200,-12.649500,-0.087757,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{-0.500483,  1.859937,-0.166023,-0.274213,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{ 0.752273,       0.0,-0.343339,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{ 0.005521,  2.072020, 0.774670,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 3.278000,-0.019000,      0.0},
/* cw_growth        */{ 0.880678,  1.030668,-0.122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15  */
{ /* index 6, FOO type = 1 */
6, HARDWOOD, "FOO",
/* d6_growth        */{-1.911680,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{-2.559060,  0.034321,      0.0, 1.281572,-0.012880,      0.0,-0.278670,      0.0,      0.0,  0.41500,-0.400000,-0.400000, 0.071864,      0.0,      0.0,      0.0},
/* cr_growth        */{ 0.314924,  0.155572,      0.0,      0.0,      0.0, 6.049900,-4.864300,-1.264200,-2.193800,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{ 0.724108,       1.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 0.205640,  0.332842, 1.320422,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{ 3.078600,  1.924200,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{ 0.768264,  0.555826, 0.160599,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-0.991461,  0.801498,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{ 4.435520, -3.300560,-0.649916,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{ 0.206178,  0.910631,-0.038421,-0.254271,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{ 0.846010,       0.0,-0.923390,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{ 0.0024277, 2.255750, 0.871080, 1.000000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 3.278000,-0.019000,      0.0,      0.0},
/* cw_growth        */{ 0.880678,  1.030668,-0.122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15  */
{ /* index 7, FPM type = 1 */
7, HARDWOOD, "FPM",
/* d6_growth        */{-1.576230,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{-1.737760,  0.034321,      0.0, 1.039708,-0.012880,      0.0,-0.278670,      0.0,      0.0, 0.415000,-0.400000,-0.400000, 0.071864,      0.0,      0.0,      0.0},
/* cr_growth        */{ 0.314924,  0.155572,      0.0,      0.0,      0.0, 6.049900,-4.864300,-1.264200,-2.193800,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{ 0.778028,       1.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 1.467927,  0.705907, 0.348202,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{ 3.429900,  1.353200,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{ 0.804766,  0.591219, 0.151474,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-1.607344,  1.156704,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{ 5.981730, -4.203110,-0.295019,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{ 0.194959,  0.261376, 0.011321,-0.150284,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{ 0.709393,       0.0,-0.319237,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{ 0.0067323, 1.96628,  0.834580, 1.000000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 3.119000,-2.284000,      0.0,      0.0},
/* cw_growth        */{ 0.880678,  1.030668,-.0122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
},

/*   0          1         2         3          4         5         6          7          8        9        10       11       12        13       14        15    */
{ /* index 8, FMZ type = 2 */
8, SHRUB, "FMZ",
/* d6_growth        */{ 0.052777, 0.046057,      0.0, 0.091103, 0.004174,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{ 0.376316,-3.461019, 1.677419,-0.099159,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cr_growth        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 0.702099, 0.617866, 1.325870,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-1.067437, 0.748448,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{ 0.528185, 0.891697,-0.067543,-0.121772,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{-5.48680,  2.692500, 0.018000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cw_growth        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.100000, 0.949400,-0.562100,-1.101110,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15 */
{ /* index 9, FDB type = 2 */
9, SHRUB, "FDB",
/* d6_growth        */{ 0.034687, 0.029844, 0.008261, 0.045849, 0.002756,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{      0.0,-0.537715,-0.168269,      0.0,-0.189138,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cr_growth        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 1.089729, 0.747993, 1.097979,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-1.111103, 0.522718,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{ 0.408897, 0.677987,-0.036506,-0.123289,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{-7.17520,  2.852000, 0.078000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cw_growth        */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.100000, 0.949400,-0.562100,-1.101110,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15 */
{ /* index 10, FSB type = 2 */
10, SHRUB, "FSB",
/* d6_growth        */{ 0.133358,  0.074102,      0.0, 0.024693,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{      0.0, -1.379933, 1.060711,-0.059576,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cr_growth        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{ 0.222940,  0.637520, 1.623455,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{-0.958757,  0.536006,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{ 0.616536,  0.154475,-0.001578,-0.103090,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{-6.909900,  2.845200, 0.078000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cw_growth        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.100000, 0.949400,-0.562100,-1.101110,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15   */
{ /* index 11, FNS type = 4 */
11, NON_STOCKED, "FNS",
/* d6_growth        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* ht_growth        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cr_growth        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_ratio      */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* crown_width      */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* max_crown_width  */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_dbh        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht            */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht           */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* n_stems_from_ht  */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_growth       */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cfvolume4        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* biomass          */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* cw_growth        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* dbh_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d6_ht_veg_cov    */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* d12_ht_veg_cov   */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
/* mortality        */{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0}
}

};





/* this function allocates an array of n_coeffs records     */
/* which is the array that will be returned. the function   */
/* then copies the local coeffs into that array and the     */
/* returns                                                  */
struct COEFFS_RECORD *con_swo_hybrid_init_coeffs( 
   unsigned long               *n_coeffs, 
   double                       *coeffs_version,
   double                       *model_version )
{

    struct COEFFS_RECORD *temp_coeffs; 
   
    /* todo: make sure the size of the coefficient records match */
    if( sizeof( struct COEFFS_RECORD ) == sizeof( struct CON_SWOHYBRID_COEFFS_RECORD ) )
    {
        /* these are defined by the model */
        *n_coeffs       = N_SWOHYBRID_CONIFERS_COEFFS;
        *coeffs_version = (double)SWOHYBRID_COEFFS_VERSION;
        *model_version = (double)SWOHYBRID_COEFFS_VERSION;

        temp_coeffs = (struct COEFFS_RECORD *)calloc( 
            *n_coeffs, sizeof( struct COEFFS_RECORD ) );

        memcpy( temp_coeffs, swo_hybrid_temp_coeffs, sizeof( swo_hybrid_temp_coeffs ) );
    }
    else
    {
        *n_coeffs       = 0;
        *coeffs_version = 0.0;
        *model_version  = 0.0;
        return NULL;
    }


   return temp_coeffs;
}

