# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title TROLL simulator
#'
#' @description
#' Wrapper of the TROLL C++ simulator with Rcpp.
#'
#' @name trollCpp
#'
#' @param global_file char. Path to the global parameters file.
#' @param climate_file char. Path to the climate file.
#' @param species_file char. Path to the species file.
#' @param day_file char. Path to the daytime file.
#' @param lidar_file char. Path to the lidar file.
#' @param forest_file char. Path to the forest file.
#' @param output_file char. Path to the output folder.
#'
#' @return Void with outputs files written in the defined folder.
#'
#' @examples
#' \dontrun{
#' trollCpp(global_file = "test/test_input_global.txt",
#'          climate_file = "test/test_input_climate.txt",
#'          species_file = "test/test_input_species.txt",
#'          day_file = "test/test_input_daily.txt",
#'          lidar_file = "",
#'          forest_file = "",
#'          output_file = "test")
#' }
#'
#' @export
trollCpp <- function(global_file, climate_file, species_file, day_file, lidar_file, forest_file, output_file) {
    invisible(.Call(`_rcontroll_trollCpp`, global_file, climate_file, species_file, day_file, lidar_file, forest_file, output_file))
}

