% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_parameters.R
\name{generate_parameters}
\alias{generate_parameters}
\title{Generate parameters}
\usage{
generate_parameters(
  cols = 200,
  rows = 200,
  HEIGHT = 70,
  length_dcell = 25,
  nbiter,
  iterperyear = 12,
  NV = 1,
  NH = 1,
  nbout = 4,
  nbspp = 45,
  SWtoPPFD = 2.27,
  p_nonvert = 0.05,
  klight = 0.63,
  phi = 0.093,
  absorptance_leaves = 0.9,
  theta = 0.7,
  g1 = 3.77,
  vC = 0.021,
  DBH0 = 0.005,
  H0 = 0.95,
  CR_min = 0.3,
  CR_a = 2.13,
  CR_b = 0.63,
  CD_a = 0,
  CD_b = 0.2,
  CD0 = 0.3,
  shape_crown = 0.72,
  dens = 1,
  fallocwood = 0.35,
  falloccanopy = 0.25,
  Cseedrain = 50000,
  nbs0 = 10,
  sigma_height = 0,
  sigma_CR = 0,
  sigma_CD = 0,
  sigma_P = 0,
  sigma_N = 0,
  sigma_LMA = 0,
  sigma_wsg = 0,
  sigma_dbhmax = 0,
  corr_CR_height = 0,
  corr_N_P = 0,
  corr_N_LMA = 0,
  corr_P_LMA = 0,
  leafdem_resolution = 30,
  p_tfsecondary = 1,
  hurt_decay = 0,
  crown_gap_fraction = 0.15,
  m = 0.013,
  m1 = 0.013,
  Cair = 400,
  LL_parameterization = 1,
  LA_regulation = 2,
  sapwood = 1,
  seedsadditional = 0,
  NONRANDOM = 1,
  GPPcrown = 0,
  BASICTREEFALL = 1,
  SEEDTRADEOFF = 0,
  CROWN_MM = 0,
  OUTPUT_extended = 1,
  extent_visual = 0
)
}
\arguments{
\item{cols}{num. Number of columns.}

\item{rows}{num. Number of rows.}

\item{HEIGHT}{num. Vertical extent of simulation.}

\item{length_dcell}{num. Linear size of a dcell.}

\item{nbiter}{num. Total number of timesteps.}

\item{iterperyear}{num. Number of iterations per year.}

\item{NV}{num. Vertical number of cells (per m).}

\item{NH}{num. Horizontal number of cells (per m).}

\item{nbout}{num. Number of outputs.}

\item{nbspp}{num. Number of species}

\item{SWtoPPFD}{num. Convert shortwave irradiance to PAR photons.}

\item{p_nonvert}{num. Light incidence parameter (difference through turbid
medium).}

\item{klight}{num. Light attenuation in the canopy following a Beer-Lambert
law.}

\item{phi}{num. Quantum yield (in micromol C/micromol photon).}

\item{absorptance_leaves}{num. Absorptance of individual leaves.}

\item{theta}{num. Parameter of the Farquhar model.}

\item{g1}{num. Parameter g1 of Medlyn et al stomatal conductance model.}

\item{vC}{num. Variance of the flexion moment.}

\item{DBH0}{num. Initial diameter at breast height (m).}

\item{H0}{num. Initial height (m).}

\item{CR_min}{num. Minimum crown radius (in m).}

\item{CR_a}{num. Crown radius log intercept or Michaelis Menten initial
growth.}

\item{CR_b}{num. Crown radius log slope or Michaelis Menten asymptotic CR.}

\item{CD_a}{num. Crown depth intercept (absolute value).}

\item{CD_b}{num. Crown depth slope (as fraction of tree height).}

\item{CD0}{num. Initial crown depth (in m).}

\item{shape_crown}{num. Crown shape parameter.}

\item{dens}{num. Initial leaf density (m^2/m^2).}

\item{fallocwood}{num. Fraction of biomass allocated to above ground wood
(branch turnover+stem).}

\item{falloccanopy}{num. Fraction of biomass allocated to canopy (leaves +
reproductive organs + twigs).}

\item{Cseedrain}{num. Constant used to scale total seed rain per hectare
across species.}

\item{nbs0}{num. Number of seeds produced and dispersed by each mature tree
when SEEDTRADEOFF is not defined.}

\item{sigma_height}{num. Intraspecific variation in tree height (lognormal).}

\item{sigma_CR}{num. Intraspecific variation in crown radius (lognormal).}

\item{sigma_CD}{num. Intraspecific variation in crown depth (lognormal).}

\item{sigma_P}{num. Intraspecific variation in leaf phosphorus (lognormal).}

\item{sigma_N}{num. Intraspecific variation in leaf nitrogen (lognormal).}

\item{sigma_LMA}{num. Intraspecific variation in leaf mass per area
(lognormal).}

\item{sigma_wsg}{num. Intraspecific variation in wood specific gravity.}

\item{sigma_dbhmax}{num. Intraspecific variation in maximum diameter.}

\item{corr_CR_height}{num. Correlation coefficient between crown radius and
tree height.}

\item{corr_N_P}{num. Correlation coefficient between leaf nitrogen and leaf
phosphorus.}

\item{corr_N_LMA}{num. Correlation coefficient between leaf nitrogen and leaf
mass per area}

\item{corr_P_LMA}{num. Correlation coefficient between leaf phosphorus and
leaf mass per area}

\item{leafdem_resolution}{num. Resolution of leaf demography model.}

\item{p_tfsecondary}{num. Probability of secondary treefall.}

\item{hurt_decay}{num. Parameter determining how tree damages are repaired.}

\item{crown_gap_fraction}{num. Fraction of gaps in the crown.}

\item{m}{num. Minimal death rate.}

\item{m1}{num. Slope of death rate m1.}

\item{Cair}{num. Atmospheric CO2 concentration in micromol/mol.}

\item{LL_parameterization}{num. Leaf lifespan parameterizations: Reich
empirical, Kikuzawa model, and Kikuzawa model with leaf plasticity (0,1,2).}

\item{LA_regulation}{num. Dynamic LA regulation: off, 1.0, 0.75, or 0.5
(0,1,2,3).}

\item{sapwood}{num. Sapwood parameterizations: constant thickness (0.04),
Fyllas percentage, Fyllas lower limit (0,1,2).}

\item{seedsadditional}{num. Excess biomass into seeds after maturation (0,1).}

\item{NONRANDOM}{num. If _NONRANDOM >= 1, the seeds for the random number
generators will be set using fixed seed in R, default for bug fixing (0,1).}

\item{GPPcrown}{num. This defines an option to compute only GPP from the
topmost value of PPFD and GPP, instead of looping within the crown (0,1).}

\item{BASICTREEFALL}{num. If defined: treefall is a source of tree death
(0,1).}

\item{SEEDTRADEOFF}{num. if defined: the number of seeds produced is
determined by NPP allocated to reproduction and seed mass, otherwise the
number of seeds is fixed (0,1).}

\item{CROWN_MM}{num. Michaelis Menten allometry for crowns instead of power
law, parameters have to be changed in other input sheets accordingly (0,1).}

\item{OUTPUT_extended}{num. extended set of ouput files (0,1).}

\item{extent_visual}{num. extent for visualization output. Unactivated when
equal 0.}
}
\value{
A data frame of global parameters.
}
\description{
Function to generate the global parameters used in the TROLL simulation. All
parameters have a default value used in French Guiana simulations.
}
\examples{

generate_parameters(nbiter = 12)

}
