% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trollsim.R
\docType{class}
\name{trollsim-class}
\alias{trollsim-class}
\title{An S4 class to represent TROLL simulations}
\value{
An empty S4 \linkS4class{trollsim} class object.
}
\description{
This is an S4 class to represent TROLL simulations.
}
\section{Slots}{

\describe{
\item{\code{name}}{char. Simulation name.}

\item{\code{path}}{char. Path to the simulation.}

\item{\code{parameters}}{numeric. Parameters of the simulation (general inputs).}

\item{\code{inputs}}{list. Simulation inputs (species, climate, daily, forest,lidar).}

\item{\code{log}}{chr. Simulation log.}

\item{\code{forest}}{df. Simulation initial and final forest.}

\item{\code{ecosystem}}{df. Ecosystem metrics.}

\item{\code{species}}{df. Species metrics (with OUTPUT_extended option).}

\item{\code{las}}{list. List with one simulated point cloud in LAS from lidar
parameters (with lidar option). The LAS format correspond to lidr::LAS.}
}}

