% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPDataFrame.R
\name{assumedUniquePix}
\alias{assumedUniquePix}
\title{Check if object was assumed to have unique HEALPix indices}
\usage{
assumedUniquePix(obj)
}
\arguments{
\item{obj}{Any object}
}
\value{
A boolean. This is TRUE if \code{obj}
is a \code{\link{CMBDataFrame}} or a \code{\link{HPDataFrame}} whose
rows were assumed to correspond to unique HEALPix pixel indices.
}
\description{
The function checks object's attribute assumedUniquePix. The attribute is True if
the  object was assumed to have rows that correspond to unique
HEALPix pixel indices.
}
\examples{

hp1 <- HPDataFrame(I=rnorm(5), nside = 1, spix = c(1,1,2,2,3))
pix(hp1)
coords(hp1, new.coords = "cartesian")
assumedUniquePix(hp1)

sky <- CMBDataFrame(nside = 32, coords = "cartesian", ordering = "nested")
sky.s <- CMBDataFrame(sky, sample.size = 100)
hpdf <- HPDataFrame(sky.s, auto.spix = TRUE)
assumedUniquePix(hpdf)

}
