% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DisplayHEALPix.R
\name{displayPixelBoundaries}
\alias{displayPixelBoundaries}
\title{Plot HEALPix pixel boundaries}
\usage{
displayPixelBoundaries(nside, eps = pi/90, col = "gray", lwd = 1,
  ordering, incl.labels = 1:(12 * nside^2), nums.col = col,
  nums.size = 1, font = 2, ...)
}
\arguments{
\item{nside}{the HEALPix nside parameter (integer number \eqn{2^k})}

\item{eps}{controls the smoothness of the plot, smaller eps
implies more samples}

\item{col}{the colour of plotted boundary lines}

\item{lwd}{the thickness of the plotted boundary lines}

\item{ordering}{optionally specify an ordering scheme
from which to plot HEALPix pixel numbers. Can be
either "ring" or "nested"}

\item{incl.labels}{If \code{ordering} is specified then
this parameter sets the pixel indices that will be
displayed (default is all indices at \code{nside})}

\item{nums.col}{specifies the colour of pixel numbers
if \code{ordering} is specified}

\item{nums.size}{specifies the size of pixel numbers
if \code{ordering} is specified}

\item{font}{A numeric font number from 1 to 5,
used if \code{ordering} is specified}

\item{...}{arguments passed to \code{rgl::plot3d}}
}
\value{
Produces a plot of the HEALPix pixel boundaries.
}
\description{
Plot the HEALPix pixel boundaries at \code{nside}
}
\examples{
displayPixelBoundaries(1, eps = pi/90, col = "red")
displayPixelBoundaries(2, eps = pi/90, col = "green")

}
