% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBWindowHelpers.R
\name{triangulate}
\alias{triangulate}
\title{Triangulate a polygonal \code{\link{CMBWindow}}}
\usage{
triangulate(win)
}
\arguments{
\item{win}{a CMBWindow object}
}
\value{
a list of CMBWindow polygons or minus.polygons,
each having 3 vertices and representing a triangle.
If winType of \code{win} does not include
"minus" then these triangles have
pairwise disjoint interiors and their union
is equal to the original polygon,
\code{win}.
Otherwise, if winType of \code{win}
does include "minus" the triangles are
the same as for the non-minus type above, but have "minus" types.
}
\description{
Triangulate a polygonal \code{\link{CMBWindow}}
}
\examples{

## Example 1

win <- CMBWindow(theta = c(2*pi/3,3*pi/4,3*pi/4, 2*pi/3),
                 phi = c(pi/4,pi/4,pi/3,pi/3))
win
plot(win)
win1 <- triangulate(win)
win1
summary(win1[[1]])
plot(win1[[1]], add= FALSE, col="green")
plot(win1[[2]], col="blue")

## Example 2: triangilation minus-type polygon

win <- CMBWindow(theta = c(pi/5,pi/3,pi/4, pi/3, pi/5),
                 phi = c(pi/5,pi/5, pi/4 ,pi/3,pi/3), set.minus =TRUE)
win
plot(win)
summary(win)
win1 <- triangulate(win)
win1
plot(win1[[1]], add= FALSE, col="green")
plot(win1[[2]], col="blue")
plot(win1[[3]], col="yellow")
summary(win1[[1]])
summary(win1[[2]])
summary(win1[[3]])

}
