% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDataFrameGenerics.R
\name{pix.CMBDataFrame}
\alias{pix.CMBDataFrame}
\title{HEALPix pixel indices from \code{\link{CMBDataFrame}}}
\usage{
\method{pix}{CMBDataFrame}(x, new.pix, ...)
}
\arguments{
\item{x}{A CMBDataFrame.}

\item{new.pix}{Optional vector of pixel indices with
length equal to \code{nrow(x)}.}

\item{...}{Unused arguments.}
}
\value{
The vector of HEALPix pixel indices or, if new.pix is specified,
a new CMBDataFrame.
}
\description{
If new.pix is unspecified then this function returns the vector of
HEALPix pixel indices from a CMBDataFrame. If new.pix is specified then
this function returns a new CMBDataFrame with the same number of rows
as \code{cmbdf}, but with pix attribute \code{new.pix}. Thus,
\code{new.pix} must have length equal to \code{nrow(cmbdf)}.
}
\examples{
## First download the map
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits", sample.size = 800000)
# pix(df)

df <- CMBDataFrame(nside = 16, sample.size = 10, ordering = "nested")
pix(df)

}
