% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDataFrameGenerics.R
\name{summary.CMBDataFrame}
\alias{summary.CMBDataFrame}
\title{Summarise a \code{\link{CMBDataFrame}}}
\usage{
\method{summary}{CMBDataFrame}(object, intensities = "I", ...)
}
\arguments{
\item{object}{A \code{\link{CMBDataFrame}}.}

\item{intensities}{the name of a column specifying CMB intensities
(or potentially another numeric quantity of interest)}

\item{...}{Unused arguments.}
}
\value{
A summary includes window's type and area,
total area covered by observations,
and main statistics for intensity values
}
\description{
This function produces a summary from a CMBDataFrame.
}
\examples{
## First download the map
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# df.sample <- CMBDataFrame(df, sample.size = 800000)
# summary(df.sample)

ns <- 16
df <- CMBDataFrame(I = rnorm(12*ns^2), nside = ns,
                   ordering = "nested")

win1 <- CMBWindow(x=0,y=3/5,z=4/5,r=0.8)
df.sample1 <- window(df, new.window = win1)
summary(df)

}
