% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{variofitCMB}
\alias{variofitCMB}
\title{Estimates parameters of variograms}
\usage{
variofitCMB(
  vario,
  ini.cov.pars,
  cov.model,
  fix.nugget = FALSE,
  nugget = 0,
  fix.kappa = TRUE,
  kappa = 0.5,
  simul.number = NULL,
  max.dist = vario$max.dist,
  weights,
  minimisation.function,
  limits = geoR::pars.limits(),
  messages,
  ...
)
}
\arguments{
\item{vario}{An object of the class \code{variogram} obtained as an output of
the function \code{\link{variogramCMB}}.}

\item{ini.cov.pars}{A vector with initial values for the variogram parameters.
The first parameter corresponds to the variance sigma^2. The second parameter
corresponds to the range phi of the correlation function.}

\item{cov.model}{A type of the variogram function. Available choices are: "matern",
"exponential","spherical", "powered.exponential", "cauchy", "gencauchy", "pure.nugget",
"askey", "c2wendland", "c4wendland", "sinepower", "multiquadric". The default is "matern"}

\item{fix.nugget}{logical. Indicates whether the nugget variance should be regarded
as fixed or be estimated. The default is FALSE.}

\item{nugget}{A value for the nugget parameter. Regarded as a fixed values if
\code{fix.nugget = TRUE} or as a initial value for the minimization algorithm if
\code{fix.nugget = FALSE}. The default is zero.}

\item{fix.kappa}{logical. Indicates whether the parameter kappa should be regarded
as fixed or be estimated. The default is TRUE.}

\item{kappa}{A value for the smoothness parameter. Regarded as a fixed values if
\code{fix.kappa = TRUE} or as a initial value for the minimization algorithm if
\code{fix.kappa = FALSE}. Required not in all covariance models, see
\code{\link{covmodelCMB}}. The default is 0.5.}

\item{simul.number}{number of simulation. Used if \code{vario} has empirical variograms
for more than one data-set (simulations). The default is NULL}

\item{max.dist}{A maximum distance to fit a variogram model. The default is
\code{x$max.dist}.}

\item{weights}{Weights used in the loss function in the minimization algorithm.}

\item{minimisation.function}{Minimization function ("optim", "nlm", "nls") to estimate
the parameters.}

\item{limits}{Lower and upper limits for the model parameters used
in the numerical minimisation by \code{minimisation.function = "optim"}.}

\item{messages}{logical. Indicates whether or not status messages are printed on
the screen.}

\item{...}{other minimisation parameters}
}
\value{
An object of the class \code{variomodel} and \code{variofit}, see
\code{\link[geoR]{variofit}}
}
\description{
This function estimates variogram parameters by fitting a parametric model
from \code{\link{covmodelCMB}} to a sample variogram. The function extends
\code{\link[geoR]{variofit}} from the package \strong{geoR}
to additional covariance models on spheres.
}
\details{
The parameter values of a variogram function from \code{\link{covmodelCMB}} are
found by numerical optimization using one of the functions: \code{\link{optim}},
\code{\link{nlm}} and \code{\link{nls}}.

The function extends \code{\link[geoR]{variofit}} from the package \strong{geoR}
to additional variogram models on spheres.  Available models are: "matern",
"exponential", "spherical", "powered.exponential", "cauchy", "gencauchy",
"pure.nugget", "askey", "c2wendland", "c4wendland", "sinepower", "multiquadric".

Additionally it rescales an empirical variogram to the range \code{[0,1]} before
numerical optimisation and then transforms all obtained results to the original
scale. If \code{ini.cov.pars} are not provided then the 5x5 grid
\code{(seq(0,max(vario$v),l=5), seq(0,vario$max.dist,l=5))}
of initial values of sigma^2  and phi is used.
}
\examples{
#
# df <- CMBDataFrame("../CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 10000)
# varcmb <- variogramCMB(cmbdf, max.dist = 0.1, num.bins = 30)
# varcmb
#
# ols <- variofitCMB(varcmb,  fix.nug=FALSE, wei="equal", cov.model= "matern")
# plot(varcmb)
# lines(ols, lty=2)
# str(ols)
#
# ols <- variofitCMB(varcmb, fix.nug = TRUE, kappa = 3, wei = "equal",
# cov.model = "askey")
# plot(varcmb, main = ols$cov.model)
# linesCMB(ols, lty = 2)
# str(ols)

}
\references{
\strong{geoR} package, \code{\link[geoR]{variofit}}, \code{\link{covmodelCMB}}
}
