% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corridor.R
\name{cap_corridor}
\alias{cap_corridor}
\title{Cap the corridor by connecting the edge end points}
\usage{
cap_corridor(edges, method = "shortest-path", network = NULL)
}
\arguments{
\item{edges}{A simple feature geometry representing the corridor edges}

\item{method}{The method employed for the capping:
\itemize{
\item \code{shortest-path} (default): find the network-based shortest-path
connections between the edge end points.
\item \code{direct}: connect the start points and the end points of the
edges via straight segments
}}

\item{network}{A spatial network object, only required if
\code{method = 'shortest-path'}}
}
\value{
An \code{\link[sf:sfc]{sf::sfc_POLYGON}} object representing the corridor
}
\description{
Cap the corridor by connecting the edge end points
}
\keyword{internal}
