% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverspace.R
\name{delineate_riverspace}
\alias{delineate_riverspace}
\title{Delineate the space surrounding a river}
\usage{
delineate_riverspace(
  river,
  occluders = NULL,
  density = 1/50,
  ray_num = 40,
  ray_length = 100
)
}
\arguments{
\item{river}{List with river surface and centerline}

\item{occluders}{Geometry of occluders}

\item{density}{Density of viewpoints}

\item{ray_num}{Number of rays as numeric vector of length one}

\item{ray_length}{Length of rays in meters as numeric vector of length one}
}
\value{
Riverspace as object of class \code{\link[sf:sfc]{sf::sfc_POLYGON}}
}
\description{
Delineate the space surrounding a river
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucharest_osm <- get_osm_example_data()
delineate_riverspace(bucharest_osm$river_surface, bucharest_osm$buildings)
\dontshow{\}) # examplesIf}
}
