% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_works.R
\name{cr_works}
\alias{cr_works}
\alias{cr_works_}
\title{Search CrossRef works (articles)}
\usage{
cr_works(dois = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, cursor = NULL, cursor_max = 5000, .progress = "none",
  ...)

cr_works_(dois = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  facet = FALSE, cursor = NULL, cursor_max = 5000, .progress = "none",
  parse = FALSE, ...)
}
\arguments{
\item{dois}{Search by a single DOI or many DOIs.}

\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at, from 1 to infinity.}

\item{limit}{Number of results to return in the query. Not relavant when searching with specific
dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use the sample parameter, 
the rows and offset parameters are ignored. Ignored unless \code{works=TRUE}}

\item{sort}{(character) Field to sort on, one of score, relevance, updated, deposited, indexed, 
or published.}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{facet}{(logical) Include facet results. Default: \code{FALSE}}

\item{cursor}{(character) Cursor character string to do deep paging. Default is None.
Pass in '*' to start deep paging. Any combination of query, filters and facets may be
used with deep paging cursors. While rows may be specified along with cursor, offset
and sample cannot be used.
See https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md#deep-paging-with-cursors}

\item{cursor_max}{(integer) Max records to retrieve. Only used when cursor param used. 
Because deep paging can result in continuous requests until all are retrieved, use this
parameter to set a maximum number of records. Of course, if there are less records
found than this value, you will get only those found.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", 
"tk", "win", and "time".  See \code{\link[plyr]{create_progress_bar}} for details 
of each. Only used when passing in multiple ids (e.g., multiple DOIs, DOI prefixes,
etc.)}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}

\item{parse}{(logical) Whether to output json \code{FALSE} or parse to 
list \code{TRUE}. Default: \code{FALSE}}
}
\description{
Search CrossRef works (articles)
}
\section{Beware}{
 
The API will only work for CrossRef DOIs.
}

\section{Functions}{

\itemize{
 \item \code{cr_works()} - Does data request and parses to data.frame for 
 easy downstream consumption
 \item \code{cr_works_()} - Does data request, and gives back json (default) or lists,
 with no attempt to parse to data.frame's
}
}
\examples{
\dontrun{
# Works funded by the NSF
cr_works(query="NSF")

# Works that include renear but not ontologies
cr_works(query="renear+-ontologies")

# Filter
cr_works(query="global state", filter=c(has_orcid=TRUE), limit=3)
# Filter by multiple fields
cr_works(filter=c(has_orcid=TRUE, from_pub_date='2004-04-04'))
# Only full text articles 
cr_works(filter=c(has_full_text = TRUE))
# has affilitation data
cr_works(filter=c(has_affiliation = TRUE))

# Querying dois
cr_works(dois='10.1063/1.3593378')
cr_works('10.1371/journal.pone.0033693')
cr_works(dois='10.1007/12080.1874-1746')
cr_works(dois=c('10.1007/12080.1874-1746','10.1007/10452.1573-5125', '10.1111/(issn)1442-9993'))

# progress bar
cr_works(dois=c('10.1007/12080.1874-1746','10.1007/10452.1573-5125'), .progress="text")

# Include facetting in results
cr_works(query="NSF", facet=TRUE)
## Get facets only, by setting limit=0
cr_works(query="NSF", facet=TRUE, limit=0)

# Sort results
cr_works(query="ecology", sort='relevance', order="asc")
res <- cr_works(query="ecology", sort='score', order="asc")
res$data$score

# Get a random number of results
cr_works(sample=1)
cr_works(sample=10)

# You can pass in dot separated fields to filter on specific fields
cr_works(filter=c(award.number='CBET-0756451', award.funder='10.13039/100000001'))

# Use the cursor for deep paging
cr_works(query="NSF", cursor = "*", cursor_max = 300, limit = 100)
cr_works(query="NSF", cursor = "*", cursor_max = 300, limit = 100, facet = TRUE)

# Low level function - does no parsing to data.frame, get json or a list
cr_works_(query = "NSF")
cr_works_(query = "NSF", parse=TRUE)
cr_works_(query="NSF", cursor = "*", cursor_max = 300, limit = 100)
cr_works_(query="NSF", cursor = "*", cursor_max = 300, limit = 100, parse=TRUE)
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}

