% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCube.R
\name{createCube}
\alias{createCube}
\title{Creating cube size NxNxN}
\usage{
createCube(N = 3, mode = "normal", scheme = c("orange", "yellow", "blue",
  "white", "green", "red"))
}
\arguments{
\item{N}{integer - size of cube. Default value is 3, and maximum is 20. More than maximum (20) is possible, however parser will ignore moving layers with number greater than 10 - you will not be able to get full varity of those cubes.}

\item{mode}{string "normal" (default) or "octa" or "void".}

\item{scheme}{string vector - colour scheme for plotting cube. Name of colours should be given in specified order: front, top, right, bottom, left, back.

Default value is c("orange","yellow","blue","white","green","red")}
}
\value{
Cube class object
}
\description{
Creates a cube object with empty moves and color scheme information
}
\examples{
# Create 3x3x3 cube with original color scheme:
cube <- createCube()
# Create 14x14x14 cube with original color scheme:
cube <- createCube(N = 14)
# Create 3x3x3 cube with "japanese" color scheme:
cube <- createCube(scheme = c("green","white","red","blue","orange","yellow"))

}
