% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_providers.R
\name{rdb_providers}
\alias{rdb_providers}
\title{Download list of DBnomics providers.}
\usage{
rdb_providers(code = FALSE,
  use_readLines = getOption("rdbnomics.use_readLines"),
  curl_config = getOption("rdbnomics.curl_config"))
}
\arguments{
\item{code}{Logical (default \code{FALSE}). If \code{TRUE}, then only the
providers are returned in a vector.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines} i.e.
through the default R internet connection. This can be used to get round the
error \code{Could not resolve host: api.db.nomics.world}.}

\item{curl_config}{Curl_handle or list (default \code{NULL}). If not
\code{NULL}, it is used to configure a proxy connection. This
configuration is passed to the function \code{curl_fetch_memory} of the package
\pkg{curl}. If it is a \code{curl_handle} object then it is considered to
be the argument \code{handle} of \code{curl_fetch_memory}. In the case of a
list, the names of the object are the arguments names of
\code{curl_fetch_memory} (except \code{url} of course). It means that
\code{curl_config = h} is equivalent to
\code{curl_config = list(handle = h)}. \cr
For \code{curl_fetch_memory} arguments see \code{\link[curl]{curl_fetch}}.
For available curl options see \code{\link[curl]{curl_options}},
\code{names(curl_options())} and
\href{https://curl.haxx.se/libcurl/c/curl_easy_setopt.html}{libcurl}.}
}
\value{
A \code{data.frame}, a \code{data.table} or a vector.
}
\description{
\code{rdb_providers} downloads the list of providers from
\href{https://db.nomics.world/}{DBnomics}.
}
\details{
By default, the function returns a \code{data.frame} (or a \code{data.table})
containing the list of providers from
\href{https://db.nomics.world/}{DBnomics} with additional informations such as
the region, the website, etc.
}
\examples{
\dontrun{
rdb_providers()

rdb_providers(code = TRUE)
}
}
\seealso{
\code{\link{rdb_last_updates}}
}
