% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCdensity.R
\name{DCdensity}
\alias{DCdensity}
\title{McCrary Sorting Test}
\usage{
DCdensity(runvar, cutpoint, bin = NULL, bw = NULL, verbose = FALSE,
  plot = TRUE, ext.out = FALSE, htest = FALSE)
}
\arguments{
\item{runvar}{numerical vector of the running variable}

\item{cutpoint}{the cutpoint (defaults to 0)}

\item{bin}{the binwidth (defaults to \code{2*sd(runvar)*length(runvar)^(-.5)})}

\item{bw}{the bandwidth to use (by default uses bandwidth selection calculation from McCrary (2008))}

\item{verbose}{logical flag specifying whether to print diagnostic information to the terminal. (defaults to \code{FALSE})}

\item{plot}{logical flag indicating whether to plot the histogram and density estimations (defaults to \code{TRUE}). The user may wrap this function in additional graphical options to modify the plot.}

\item{ext.out}{logical flag indicating whether to return extended output. When \code{FALSE} (the default) \code{DCdensity} will return only the p-value of the test. When \code{TRUE}, \code{DCdensity} will return the additional information documented below.}

\item{htest}{logical flag indicating whether to return an \code{"htest"} object compatible with base R's hypothesis test output.}
}
\value{
If \code{ext.out} is \code{FALSE}, only the p value will be returned. Additional output is enabled when \code{ext.out} is \code{TRUE}. In this case, a list will be returned with the following elements:
\item{theta}{the estimated log difference in heights at the cutpoint}
\item{se}{the standard error of \code{theta}}
\item{z}{the z statistic of the test}
\item{p}{the p-value of the test. A p-value below the significance threshhold indicates that the user can reject the null hypothesis of no sorting.}
\item{binsize}{the calculated size of bins for the test}
\item{bw}{the calculated bandwidth for the test}
\item{cutpoint}{the cutpoint used}
\item{data}{a dataframe for the binning of the histogram. Columns are \code{cellmp} (the midpoints of each cell) and \code{cellval} (the normalized height of each cell)}
}
\description{
\code{DCdensity} implements the McCrary (2008) sorting test.
}
\examples{
#No discontinuity
x<-runif(1000,-1,1)
DCdensity(x,0)

#Discontinuity
x<-runif(1000,-1,1)
x<-x+2*(runif(1000,-1,1)>0&x<0)
DCdensity(x,0)
}
\author{
Drew Dimmery <\email{drewd@nyu.edu}>
}
\references{
McCrary, Justin. (2008) "Manipulation of the running variable in the regression discontinuity design: A density test," \emph{Journal of Econometrics}. 142(2): 698-714. \url{http://dx.doi.org/10.1016/j.jeconom.2007.05.005}
}

