% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdplotdensity.R
\name{rdplotdensity}
\alias{rdplotdensity}
\title{Density Plot}
\usage{
rdplotdensity(rdd, X, plotRange = NULL, plotN = 10, plotGrid = c("es",
  "qs"), alpha = 0.05, type = NULL, CItype = NULL, title = "",
  xlabel = "", ylabel = "", lty = NULL, lwd = NULL, lcol = NULL,
  pty = NULL, pwd = NULL, pcol = NULL, CIshade = NULL, CIcol = NULL,
  legendTitle = NULL, legendGroups = NULL)
}
\arguments{
\item{rdd}{Object returned by \code{\link{rddensity}}}

\item{X}{Numeric vector or one dimensional matrix / data frame, the running variable.}

\item{plotRange}{Numeric, specifies the lower and upper bound for density plot. By default it is
three bandwidths around the cutoff.}

\item{plotN}{Numeric, specifies the number of grid points used for density plot on each side.
If more than one is provided, they will be applied to the two sides accordingly. By default 10
points are used on each side.}

\item{plotGrid}{String, specifies the position of grid points. Can be either evenly spaced (default, \code{"es"}),
or quantile spaced (\code{"qs"}).}

\item{alpha}{Numeric scalar between 0 and 1, the significance level for plotting
confidence regions. If more than one is provided, they will be applied to the two sides
accordingly.}

\item{type}{String, one of \code{"line"} (default), \code{"points"} or \code{"both"}, how
the point estimates are plotted. If more than one is provided, they will be applied to the two sides
accordingly.}

\item{CItype}{String, one of \code{"region"} (shaded region, default), \code{"line"} (dashed lines),
\code{"ebar"} (error bars), \code{"all"} (all of the previous) or \code{"none"} (no confidence region),
how the confidence region should be plotted. If more than one is provided, they will be applied to the two sides
accordingly.}

\item{title, xlabel, ylabel}{Strings, title of the plot and labels for x- and y-axis.}

\item{lty}{Line type for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for solid line, \code{2} for dashed line, \code{3} for dotted line.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to the two sides accordingly.}

\item{lwd}{Line width for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. Should be strictly positive. For other options, see the instructions for
\code{\link{ggplot2}} or \code{\link{par}}. If more than one is provided, they will be applied
to the two sides accordingly.}

\item{lcol}{Line color for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3} for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to the two sides
accordingly.}

\item{pty}{Scatter plot type for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. For options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to the two sides
accordingly.}

\item{pwd}{Scatter plot size for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. Should be strictly positive. If more than one is provided, they will be applied to the two sides
accordingly.}

\item{pcol}{Scatter plot color for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to the two sides
accordingly.}

\item{CIshade}{Numeric, opaqueness of the confidence region, should be between 0 (transparent) and
1. Default is 0.2. If more than one is provided, they will be applied to the two sides
accordingly.}

\item{CIcol}{color for confidence region. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to the two sides
accordingly.}

\item{legendTitle}{String, title of legend.}

\item{legendGroups}{String Vector, group names used in legend.}
}
\value{
\item{Estl, Estr}{Matrices containing estimation results on the two side, with (1) \code{grid} (grid points), (2) \code{bw} (bandwidths), (3) \code{nh}
  (effective/local sample sizes), (4) \code{f_p} (point estimates with p-th order local polynomial),
  (5) \code{f_q} (point estimates with q-th order local polynomial, only if option \code{q} is nonzero),
  (6) \code{se_p} (standard error corresponding to \code{f_p}), and (7) \code{se_q} (standard error
  corresponding to \code{f_q}).}
\item{Estplot}{A stadnard \code{ggplot} object is returned, hence can be used for further customization.}
}
\description{
\code{rdplotdensity} constructs density plot near the cutoff. It is based on the
  local polynomial density estimators proposed in \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_LocPolDensity.pdf}{Cattaneo, Jansson and Ma (2017a)}.

Companion command: \code{\link{rddensity}} for manipulation testing.
  A companion \code{Stata} package is described in \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_Stata.pdf}{Cattaneo, Jansson and Ma (2017b)}.

Related Stata and R packages useful for inference in regression discontinuity (RD)
  designs are described at \url{https://sites.google.com/site/rdpackages}.
}
\examples{
# density being discontinuous
set.seed(42)
x <- rnorm(2000, mean = -0.5); x[x>0] <- x[x>0] * 2
rdd <- rddensity(X = x)
plot <- rdplotdensity(rdd, x, plotRange = c(-2, 2), plotN = 25)
}
\references{
M. D. Cattaneo, M. Jansson and X. Ma. (2017a).  \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_LocPolDensity.pdf}{Simple Local Polynomial Density Estimators}. Working Paper, University of Michigan.

M. D. Cattaneo, M. Jansson and X. Ma. (2017b). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_Stata.pdf}{rddensity: Manipulation Testing based on Density Discontinuity}. Working Paper, University of Michigan.
}
\seealso{
\code{\link{rddensity}}
}
\author{
Matias D. Cattaneo, University of Michigan.  \email{cattaneo@umich.edu}.

Michael Jansson, University of California, Berkeley.  \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
}
