% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docDscr_variables.R
\name{ddi_docDscr}
\alias{ddi_docDscr}
\alias{ddi_docStatus}
\alias{ddi_guide}
\title{docDscr and its children}
\usage{
ddi_docDscr(...)

ddi_docStatus(...)

ddi_guide(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
The Document Description consists of bibliographic information describing the
DDI-compliant document itself as a whole. This Document Description can be
considered the wrapper or header whose elements uniquely describe the full
contents of the compliant DDI file. Since the Document Description section
is used to identify the DDI-compliant file within an electronic resource
discovery environment, this section should be as complete as possible. The
author in the Document Description should be the individual(s) or
organization(s) directly responsible for the intellectual content of the DDI
version, as distinct from the person(s) or organization(s) responsible for
the intellectual content of the earlier paper or electronic edition from
which the DDI edition may have been derived. The producer in the Document
Description should be the agency or person that prepared the marked-up
document. Note that the Document Description section contains a
Documentation Source subsection consisting of information about the source
of the DDI-compliant file-- that is, the hardcopy or electronic codebook
that served as the source for the marked-up codebook. These sections allow
the creator of the DDI file to produce version, responsibility, and other
descriptions relating to both the creation of that DDI file as a separate
and reformatted version of source materials (either print or electronic) and
the original source materials themselves. More information on this element,
especially the allowed attributes, can be found in the references.
}
\details{
\emph{Parent node}

\code{docDscr} is contained in \code{codeBook}.

\emph{docDscr specific child nodes}
\itemize{
\item \code{ddi_docStatus()} indicates if the documentation is being
presented/distributed before it has been finalized. Some data producers and
social science data archives employ data processing strategies that provide
for release of data and documentation at various stages of processing. The
element may be repeated to support multiple language expressions of the
content.
\item \code{ddi_guide()} is the list of terms and definitions used in the
documentation. Provided to assist users in using the document correctly.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_citation]{ddi_citation()}}
\item \code{\link[=ddi_controlledVocabUsed]{ddi_controlledVocabUsed()}}
\item \code{\link[=ddi_docSrc]{ddi_docSrc()}}
\item \code{\link[=ddi_notes]{ddi_notes()}}
}
}

\examples{
ddi_docDscr()

# Functions that need to be wrapped in ddi_docDscr()

ddi_docStatus("This marked-up document includes a provisional data dictionary...")

ddi_guide("List of terms and definitions")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/docDscr.html}{docDscr documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/docStatus.html}{docStatus documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/guide.html}{guide documentation}
}
