% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docroot.R
\name{ddi_otherMat}
\alias{ddi_otherMat}
\title{otherMat and its children}
\usage{
ddi_otherMat(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object
}
\description{
This section allows for the inclusion of other materials that are related to
the study as identified and labeled by the DTD/Schema users (encoders). The
materials may be entered as PCDATA (ASCII text) directly into the document
(through use of the "txt" element). This section may also serve as a
"container" for other electronic materials such as setup files by providing
a brief description of the study-related materials accompanied by the attributes
"type" and "level" defining the material further. Other
Study-Related Materials may include: questionnaires, coding notes,
SPSS/SAS/Stata setup files (and others), user manuals, continuity guides,
sample computer software programs, glossaries of terms, interviewer/project
instructions, maps, database schema, data dictionaries, show cards, coding
information, interview schedules, missing values information, frequency
files, variable maps, etc. More information on this element, especially
the allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{otherMat} is contained in the following elements: \code{codeBook} and \code{otherMat}.
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_citation]{ddi_citation()}}
\item \code{\link[=ddi_labl]{ddi_labl()}}
\item \code{\link[=ddi_notes]{ddi_notes()}}
\item \code{\link[=ddi_otherMat]{ddi_otherMat()}}
\item \code{\link[=ddi_table]{ddi_table()}}
\item \code{\link[=ddi_txt]{ddi_txt()}}
}
}

\examples{
ddi_otherMat()

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/otherMat.html}{otherMat documentation}
}
