% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DecisionTree.R
\docType{class}
\name{DecisionTree}
\alias{DecisionTree}
\title{\verb{DecisionTree} class}
\description{
An R6 class to represent a decision tree
}
\details{
A class to represent a decision tree. An object contains a tree of
decision nodes, chance nodes and leaf nodes, connected by edges
(either actions or reactions) and which satisfies the following
conditions:
\enumerate{
\item{Nodes and edges must form a tree with a single root and
there must be a unique path from the root to each node.
In graph theory terminology, the directed graph formed by the nodes
and edges must be an \dfn{arborescence}.}
\item{Each node must inherit from one of \verb{DecisionNode},
\code{ChanceNode} or \verb{LeafNode}. Formally the set of vertices
must be a disjoint union of sets of decision nodes, chance nodes
and leaf nodes.}
\item{All and only leaf nodes must have no children.}
\item{Each edge must inherit from either \verb{Action} or
\code{Reaction}.}
\item{All and only edges that have source endpoints joined to 
decision nodes must inherit from \verb{Action}.}
\item{All and only edges that have source endpoints joined to 
chance nodes must inherit from \verb{Reaction}.}
\item{The sum of probabilities of each set of reaction edges 
with a common source endpoint must be 1.}
\item{Each \verb{DecisionNode} must have a label, and the labels of all
\code{DecisionNodes} must be unique within the model.}
\item{Each \verb{Action} must have a label, and the labels of  
\code{Action}s that share a common source endpoint must be unique.}
}
}
\references{
{
  Briggs A, Claxton K, Sculpher M. Decision modelling for health economic 
  evaluation. Oxford, UK: Oxford University Press; 2006.

  Briggs AH, Weinstein MC, Fenwick EAL, Karnon J, Sculpher MJ, Paltiel AD.
  Model Parameter Estimation and Uncertainty: A Report of the 
  \acronym{ISPOR-SMDM} Modeling Good Research Practices Task Force-6. 
  \emph{Value in Health} 2012;\bold{15}:835–42, 
  \doi{10.1016/j.jval.2012.04.014}.

  Kamiński B, Jakubczyk M, Szufel P. A framework for sensitivity analysis of
  decision trees. \emph{Central European Journal of Operational Research}
  2018;\bold{26}:135–59, \doi{10.1007/s10100-017-0479-6}.
}
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super classes}{
\code{\link[rdecision:Graph]{rdecision::Graph}} -> \code{\link[rdecision:Digraph]{rdecision::Digraph}} -> \code{\link[rdecision:Arborescence]{rdecision::Arborescence}} -> \code{DecisionTree}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DecisionTree$new()}}
\item \href{#method-decision_nodes}{\code{DecisionTree$decision_nodes()}}
\item \href{#method-chance_nodes}{\code{DecisionTree$chance_nodes()}}
\item \href{#method-leaf_nodes}{\code{DecisionTree$leaf_nodes()}}
\item \href{#method-actions}{\code{DecisionTree$actions()}}
\item \href{#method-modvars}{\code{DecisionTree$modvars()}}
\item \href{#method-modvar_table}{\code{DecisionTree$modvar_table()}}
\item \href{#method-draw}{\code{DecisionTree$draw()}}
\item \href{#method-is_strategy}{\code{DecisionTree$is_strategy()}}
\item \href{#method-strategy_table}{\code{DecisionTree$strategy_table()}}
\item \href{#method-strategy_paths}{\code{DecisionTree$strategy_paths()}}
\item \href{#method-evaluate_walks}{\code{DecisionTree$evaluate_walks()}}
\item \href{#method-evaluate}{\code{DecisionTree$evaluate()}}
\item \href{#method-tornado}{\code{DecisionTree$tornado()}}
\item \href{#method-clone}{\code{DecisionTree$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="degree">}\href{../../rdecision/html/Graph.html#method-degree}{\code{rdecision::Graph$degree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="edge_index">}\href{../../rdecision/html/Graph.html#method-edge_index}{\code{rdecision::Graph$edge_index()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="graph_adjacency_matrix">}\href{../../rdecision/html/Graph.html#method-graph_adjacency_matrix}{\code{rdecision::Graph$graph_adjacency_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_edge">}\href{../../rdecision/html/Graph.html#method-has_edge}{\code{rdecision::Graph$has_edge()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_vertex">}\href{../../rdecision/html/Graph.html#method-has_vertex}{\code{rdecision::Graph$has_vertex()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="is_simple">}\href{../../rdecision/html/Graph.html#method-is_simple}{\code{rdecision::Graph$is_simple()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="neighbours">}\href{../../rdecision/html/Graph.html#method-neighbours}{\code{rdecision::Graph$neighbours()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="order">}\href{../../rdecision/html/Graph.html#method-order}{\code{rdecision::Graph$order()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="size">}\href{../../rdecision/html/Graph.html#method-size}{\code{rdecision::Graph$size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="vertex_index">}\href{../../rdecision/html/Graph.html#method-vertex_index}{\code{rdecision::Graph$vertex_index()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="digraph_adjacency_matrix">}\href{../../rdecision/html/Digraph.html#method-digraph_adjacency_matrix}{\code{rdecision::Digraph$digraph_adjacency_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="digraph_incidence_matrix">}\href{../../rdecision/html/Digraph.html#method-digraph_incidence_matrix}{\code{rdecision::Digraph$digraph_incidence_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="direct_predecessors">}\href{../../rdecision/html/Digraph.html#method-direct_predecessors}{\code{rdecision::Digraph$direct_predecessors()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="direct_successors">}\href{../../rdecision/html/Digraph.html#method-direct_successors}{\code{rdecision::Digraph$direct_successors()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_acyclic">}\href{../../rdecision/html/Digraph.html#method-is_acyclic}{\code{rdecision::Digraph$is_acyclic()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_arborescence">}\href{../../rdecision/html/Digraph.html#method-is_arborescence}{\code{rdecision::Digraph$is_arborescence()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_connected">}\href{../../rdecision/html/Digraph.html#method-is_connected}{\code{rdecision::Digraph$is_connected()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_polytree">}\href{../../rdecision/html/Digraph.html#method-is_polytree}{\code{rdecision::Digraph$is_polytree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_tree">}\href{../../rdecision/html/Digraph.html#method-is_tree}{\code{rdecision::Digraph$is_tree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_weakly_connected">}\href{../../rdecision/html/Digraph.html#method-is_weakly_connected}{\code{rdecision::Digraph$is_weakly_connected()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="paths">}\href{../../rdecision/html/Digraph.html#method-paths}{\code{rdecision::Digraph$paths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="topological_sort">}\href{../../rdecision/html/Digraph.html#method-topological_sort}{\code{rdecision::Digraph$topological_sort()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="walk">}\href{../../rdecision/html/Digraph.html#method-walk}{\code{rdecision::Digraph$walk()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arborescence" data-id="is_leaf">}\href{../../rdecision/html/Arborescence.html#method-is_leaf}{\code{rdecision::Arborescence$is_leaf()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arborescence" data-id="is_parent">}\href{../../rdecision/html/Arborescence.html#method-is_parent}{\code{rdecision::Arborescence$is_parent()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arborescence" data-id="postree">}\href{../../rdecision/html/Arborescence.html#method-postree}{\code{rdecision::Arborescence$postree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arborescence" data-id="root">}\href{../../rdecision/html/Arborescence.html#method-root}{\code{rdecision::Arborescence$root()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arborescence" data-id="root_to_leaf_paths">}\href{../../rdecision/html/Arborescence.html#method-root_to_leaf_paths}{\code{rdecision::Arborescence$root_to_leaf_paths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arborescence" data-id="siblings">}\href{../../rdecision/html/Arborescence.html#method-siblings}{\code{rdecision::Arborescence$siblings()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new decision tree. The tree must consist of a set of
nodes and a set of edges which satisfy the conditions given
in the details section of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$new(V, E)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{V}}{A list of nodes.}

\item{\code{E}}{A list of edges.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \verb{DecisionTree} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-decision_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-decision_nodes}{}}}
\subsection{Method \code{decision_nodes()}}{
Find the decision nodes in the tree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$decision_nodes(what = "node")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{A character string defining what to return. Must be one
of "node", "label" or "index".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of \verb{DecisionNode} objects (for what="node"); a list
of character strings (for what="label"); or a list of integer indexes of 
the decision nodes (for what="index").
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chance_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-chance_nodes}{}}}
\subsection{Method \code{chance_nodes()}}{
Find the chance nodes in the tree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$chance_nodes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \verb{ChanceNode} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-leaf_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-leaf_nodes}{}}}
\subsection{Method \code{leaf_nodes()}}{
Find the leaf nodes in the tree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$leaf_nodes(what = "node")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{One of "node" (returns Node objects), "label" (returns the
leaf node labels) or "index" (returns the vertex index of the leaf
nodes).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of \verb{LeafNode} objects (for what="node"); a list
of character strings (for what="label"); or a list of integer indexes of 
the decision nodes (for what="index").
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-actions"></a>}}
\if{latex}{\out{\hypertarget{method-actions}{}}}
\subsection{Method \code{actions()}}{
Return the edges that have the specified decision node as their source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$actions(d)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{d}}{A decision node.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of \verb{Action} edges.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables of type \verb{ModVar} that have been 
specified as values associated with the nodes and edges of the tree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$modvars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \verb{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvar_table"></a>}}
\if{latex}{\out{\hypertarget{method-modvar_table}{}}}
\subsection{Method \code{modvar_table()}}{
Tabulate the model variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$modvar_table(expressions = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expressions}}{A logical that defines whether expression model
variables should be included in the tabulation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Data frame with one row per model variable, as follows:
\describe{
\item{Description}{As given at initialization.}
\item{Units}{Units of the variable.}
\item{Distribution}{Either the uncertainty distribution, if
it is a regular model variable, or the expression used to create it,
if it is an \verb{ExprModVar}.}
\item{Mean}{Mean; calculated from means of operands if
an expression.}
\item{E}{Expectation; estimated from random sample if expression, 
mean otherwise.}
\item{SD}{Standard deviation; estimated from random sample if
expression, exact value otherwise.}
\item{Q2.5}{p=0.025 quantile; estimated from random sample if
expression, exact value otherwise.}
\item{Q97.5}{p=0.975 quantile; estimated from random sample if
expression, exact value otherwise.}
\item{Est}{TRUE if the quantiles and SD have been estimated by 
random sampling.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-draw"></a>}}
\if{latex}{\out{\hypertarget{method-draw}{}}}
\subsection{Method \code{draw()}}{
Draw the decision tree to the current graphics output. Uses
the algorithm of Walker (1989) to distribute the nodes compactly (see
the \link{Arborescence} class help for details).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$draw(border = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{border}}{If TRUE draw a light grey border around the plot area.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_strategy"></a>}}
\if{latex}{\out{\hypertarget{method-is_strategy}{}}}
\subsection{Method \code{is_strategy()}}{
Tests whether a strategy (a unanimous prescription of an
action in each decision node, specified as a list of nodes) is a valid
strategy for this decision tree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$is_strategy(strategy)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{strategy}}{A list of Action edges.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the strategy is valid for this tree. Throws an
exception if the argument is not a list of Action edges. Returns
FALSE if the list of Action edges are not a valid strategy.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strategy_table"></a>}}
\if{latex}{\out{\hypertarget{method-strategy_table}{}}}
\subsection{Method \code{strategy_table()}}{
Find all potential strategies for the decision tree. A
strategy is a unanimous prescription of the actions at each decision 
node. If there are decision nodes that are descendants of other nodes
in the tree, the strategies returned will not necessarily be unique.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$strategy_table(what = "index", select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{what}}{A character string defining what to return. Must be one
of "label" or "index".}

\item{\code{select}}{A single strategy (given as a list of action edges, with
one action edge per decision node). If provided, only that strategy
is selected from the returned table. Intended for tabulating a
single strategy into a readable form.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame where each row is a potential strategy 
and each column is a Decision Node. Values are either the index of each
action edge, or their label.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strategy_paths"></a>}}
\if{latex}{\out{\hypertarget{method-strategy_paths}{}}}
\subsection{Method \code{strategy_paths()}}{
Find all paths walked in each possible strategy. A strategy 
is a unanimous prescription of an action in each decision node. Some 
paths can be walked in more than one strategy, if there exist paths
that do not pass a decision node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$strategy_paths()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame, where each row is a path walked in a strategy. The
structure is similar to that returned by \code{strategy_table} but 
includes an extra column, 'Leaf' which gives the leaf node index of each
path, and there is one row for each path in each strategy.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-evaluate_walks"></a>}}
\if{latex}{\out{\hypertarget{method-evaluate_walks}{}}}
\subsection{Method \code{evaluate_walks()}}{
Evaluate the components of pay-off associated with a set of walks in the
decision tree. For each walk, probability, cost, benefit and utility are
calculated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$evaluate_walks(W)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{W}}{A list of root-to-leaf walks. Each walk must start with the
root node and end with a leaf node. Normally this is all the root to leaf
paths in a tree.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
There is minimal checking of the argument because this function 
is intended to be called repeatedly during tree evaluation, including
PSA. The argument P is expected to be obtained from 
\code{root_to_leaf_paths}.
}

\subsection{Returns}{
A matrix (pay-off table) with one row per path and columns
organized as follows:
\describe{
\item{Leaf}{The unique identifier of the path, taken to be the index 
of the terminal (leaf) node.}
\item{Probability}{The probability of traversing the pathway. }
\item{Path.Cost}{The cost of traversing the pathway.}
\item{Path.Benefit}{The benefit derived from traversing the pathway.}
\item{Path.Utility}{The utility associated with the outcome (leaf node).}
\item{Path.QALY}{The QALYs associated with the outcome (leaf node).}
\item{Cost}{Path.Cost \eqn{*} probability of traversing the pathway.}
\item{Benefit}{Path.Benefit \eqn{*} probability of traversing the 
pathway.}
\item{Utility}{Path.Utility \eqn{*} probability of traversing the
pathway.}
\item{QALY}{Path.QALY \eqn{*} probability of traversing the
pathway.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-evaluate"></a>}}
\if{latex}{\out{\hypertarget{method-evaluate}{}}}
\subsection{Method \code{evaluate()}}{
Evaluate each strategy. Starting with the root, the function
works though all possible paths to leaf nodes and computes the 
probability, cost, benefit and utility of each, then aggregates 
by strategy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$evaluate(setvars = "expected", N = 1, by = "strategy")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{setvars}}{One of "expected" (evaluate with each model variable at
its mean value), "random" (sample each variable from its uncertainty 
distribution and evaluate the model), "q2.5", "q50", "q97.5" (set each
model variable to its 2.5\%, 50\% or 97.5\% quantile, respectively, and
evaluate the model), "current" (leave each model variable at its current
value prior to calling the function and evaluate the model).}

\item{\code{N}}{Number of replicates. Intended for use with PSA 
(\code{modvars="random"}); use with \code{modvars="expected"}
will be repetitive and uninformative.}

\item{\code{by}}{One of {"path", "strategy"}. If "path", the table has one row
per path walked per strategy, per run, and includes the label of the
terminating leaf node to identify each path. if "strategy" (the default),
the table is aggregated by strategy, i.e. there is one row per strategy,
per run and there is no "Leaf" column.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with one row per strategy per run and columns
organized as follows:
\describe{
  \item{Leaf}{The label of the leaf that terminates the path, 
  for by='path'.}
  \item{Strategy}{The strategy expressed as the values of the action 
  edges emanating from each decision node.}
  \item{Run}{The run number}
  \item{Probability}{Probability (1 if by='strategy')}
  \item{Cost}{Aggregate cost of the strategy.}
  \item{Benefit}{Aggregate benefit of the strategy.}
  \item{Utility}{Aggregate utility of the strategy.}
  \item{QALY}{Aggregate QALY of the strategy.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tornado"></a>}}
\if{latex}{\out{\hypertarget{method-tornado}{}}}
\subsection{Method \code{tornado()}}{
Create a "tornado" diagram to compare two strategies for traversing
the decision tree. A strategy is a unanimous prescription of the actions
at each decision node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$tornado(index, ref, outcome = "cost", exclude = NULL, draw = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{The index strategy (option) to be evaluated.}

\item{\code{ref}}{The reference strategy (option) with which the index strategy
will be compared.}

\item{\code{outcome}}{One of \verb{"cost"} or \verb{"ICER"}. For \verb{"cost"}
(e.g. in cost
consequence analysis), the x axis is cost saved (cost of reference minus
cost of index), on the presumption that the new technology will be cost
saving at the point estimate. For \verb{"ICER"} the x axis is
\eqn{\Delta C/\Delta E} and is expected to be positive at the point 
estimate (i.e. in the NE or SW quadrants of the cost-effectiveness 
plane), where \eqn{\Delta C} is cost of index minus cost of reference, 
and \eqn{\Delta E} is utility of index minus utility of reference.}

\item{\code{exclude}}{A list of descriptions of model variables to be excluded
from the tornado.}

\item{\code{draw}}{TRUE if the graph is to be drawn; otherwise return the
data frame silently.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The extreme values of each input variable are the upper and 
lower 95\% confidence limits of the uncertainty distributions of each 
variable. This ensures that the range of each input is defensible 
(Briggs 2012).
}

\subsection{Returns}{
A data frame with one row per input model variable and columns
for: minimum value of the variable, maximum value of the variable,
minimum value of the outcome and maximum value of the outcome. NULL
if there are no \verb{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionTree$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
