% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastService.R
\name{dfp_getDeliveryForecast}
\alias{dfp_getDeliveryForecast}
\title{getDeliveryForecast}
\usage{
dfp_getDeliveryForecast(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getDeliveryForecastResponse
}
\description{
Gets the delivery forecast for a list of ProspectiveLineItem objects in a single delivery simulation with line items potentially contending with each other. A delivery forecast reports the number of units that will be delivered to each line item given the line item goals and contentions from other line items. Gets the delivery forecast for a list of ProspectiveLineItem objects in a single delivery simulation with line items potentially contending with each other. A delivery forecast reports the number of units that will be delivered to each line item given the line item goals and contentions from other line items. @param lineItems line items to be forecasted for delivery @param forecastOptions options controlling the forecast Gets the delivery forecast for a list of ProspectiveLineItem objects in a single delivery simulation with line items potentially contending with each other. A delivery forecast reports the number of units that will be delivered to each line item given the line item goals and contentions from other line items. @param lineItems line items to be forecasted for delivery @param forecastOptions options controlling the forecast
}
\examples{
\dontrun{
filter <- "WHERE Status='DELIVERING' LIMIT 1"
one_li <- dfp_getLineItemsByStatement(list(filterStatement=list(query=filter)))[[1]]
hypothetical_line_item <- list(lineItem=
                               list(id=one_li$id,
                                    startDateTime=one_li$startDateTime,
                                    endDateTime=dfp_date_to_list(Sys.Date()+100),
                                    lineItemType=one_li$lineItemType,
                                    costType=one_li$costType, 
                                    primaryGoal=one_li$primaryGoal, 
                                    targeting=one_li$targeting))
request_data <- list(lineItems=hypothetical_line_item,
                     forecastOptions=list(ignoredLineItemIds=NULL))
dfp_getDeliveryForecast_result <- dfp_getDeliveryForecast(request_data)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ForecastService#getDeliveryForecast}{Google Documentation for getDeliveryForecast}
}
