% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProductPackageItemService.R
\name{dfp_createProductPackageItems}
\alias{dfp_createProductPackageItems}
\title{ProductPackageItemService}
\usage{
dfp_createProductPackageItems(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createProductPackageItemsResponse
}
\description{
Provides methods for creating and retrieving ProductPackageItem objects.
}
\details{
A ProductPackageItem represents a product which will be associated with
a ProductPackage.
To use this service, you need to have the new sales
management solution enabled on your network. If you do not see a "Sales"
tab in \href{https://www.google.com/dfp}{DoubleClick for Publishers (DFP)},
you will not be able to use this service.

createProductPackageItems

Creates new ProductPackageItem objects.
}
\examples{
\dontrun{
 res <- dfp_createProductPackageItems(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/ProductPackageItemService#createProductPackageItems}{Google Documentation for createProductPackageItems}
}
