% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfp_utils.R
\name{dfp_full_report_wrapper}
\alias{dfp_full_report_wrapper}
\title{Take report request and return data.frame}
\usage{
dfp_full_report_wrapper(request_data, 
                               check_interval=3, 
                               max_tries=20, 
                               verbose=FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP 
request (XML format, but passed as character string)}

\item{check_interval}{a numeric specifying seconds to wait between report 
status requests to check if complete}

\item{max_tries}{a numeric specifying the maximum number of times to check 
whether the report is complete before the function essentially times out}

\item{verbose}{a logical indicating whether to print the report URL}
}
\value{
a \code{data.frame} of report results as specified by the request_data
}
\description{
Take a report request and manage all aspects for user
until returning a data.frame or error
}
\examples{
\dontrun{
request_data <- list(reportJob =
                       list(reportQuery =
                              list(dimensions = 'MONTH_AND_YEAR',
                                   dimensions = 'AD_UNIT_ID',
                                   dimensions = 'AD_UNIT_NAME',
                                   dimensions = 'ADVERTISER_NAME',
                                   dimensions = 'ORDER_NAME',
                                   dimensions = 'LINE_ITEM_NAME',
                                   adUnitView = 'FLAT',
                                   columns = 'AD_SERVER_IMPRESSIONS', 
                                   columns = 'AD_SERVER_CLICKS',
                                   dateRangeType = 'LAST_WEEK')))
report_data <- dfp_full_report_wrapper(request_data)
}
}
\seealso{
\link{dfp_runReportJob}

\link{dfp_getReportJobStatus}

\link{dfp_getReportDownloadURL}
}
