% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DaiAuthenticationKeyService.R
\name{dfp_performDaiAuthenticationKeyAction}
\alias{dfp_performDaiAuthenticationKeyAction}
\title{performDaiAuthenticationKeyAction}
\usage{
dfp_performDaiAuthenticationKeyAction(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a performDaiAuthenticationKeyActionResponse
}
\description{
Performs actions on DaiAuthenticationKey objects that match the given \{@link Statement query\}.
DAI authentication keys cannot be deactivated if there are active LiveStreamEvents or Content Sources that are using them.
}
\examples{
\dontrun{
 res <- dfp_performDaiAuthenticationKeyAction(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/DaiAuthenticationKeyService#performDaiAuthenticationKeyAction}{Google Documentation for performDaiAuthenticationKeyAction}
}
