% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity-components.R
\name{norm_beta}
\alias{norm_beta}
\title{Normalised beta (low level diversity component)}
\usage{
norm_beta(meta)
}
\arguments{
\item{meta}{object of class \code{metacommunity}.}
}
\value{
Returns an object of class \code{relativeentropy}.
}
\description{
Calculates the low-level diversity component necessary for calculating
normalised beta diversity.
}
\details{
Values generated from \code{norm_beta()} may be input into \code{subdiv()} and
\code{metadiv()} to calculate normalised subcommunity/metacommunity beta
diversity.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate normalised beta component
norm_beta(meta)

}
\references{
Reeve, R., T. Leinster, C. Cobbold, J. Thompson, N. Brummitt, 
S. Mitchell, and L. Matthews. 2014. How to partition diversity. 
arXiv 1404.6520:1–9.
}
