% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity-components.R
\name{raw_alpha}
\alias{raw_alpha}
\title{Raw alpha (low level diversity component)}
\usage{
raw_alpha(meta)
}
\arguments{
\item{meta}{object of class \code{metacommunity}.}
}
\value{
Returns an object of class \code{powermean}.
}
\description{
Calculates the low-level diversity component necessary for calculating alpha
diversity.
}
\details{
Values generated from \code{raw_alpha()} may be input into \code{subdiv()} and
\code{metadiv()} to calculate raw subcommunity/metacommunity alpha diversity.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate raw alpha component
raw_alpha(meta)

}
\references{
Reeve, R., T. Leinster, C. Cobbold, J. Thompson, N. Brummitt, 
S. Mitchell, and L. Matthews. 2016. How to partition diversity. 
arXiv 1404.6520v3:1–9.
}
