% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virustotal_cat.R
\name{virustotal_cat}
\alias{virustotal_cat}
\title{Get Category from Virustotal}
\usage{
virustotal_cat(domain = NULL, apikey = NULL)
}
\arguments{
\item{domain}{domain name}

\item{apikey}{virustotal API key}
}
\value{
data.frame with 7 columns: domain, bitdefender, dr_web, alexa, google, websense, trendmicro
}
\description{
Returns category of content from 6 major services including: BitDefender, Dr. Web, Alexa (DMOZ), Google, 
Websense, and Trendmicro. Not all services will have categories for all the domains. When the categories are
not returned for a particular domain, we return a NA.
}
\details{
Get the API Access Key from \url{http://www.virustotal.com/}. Either pass the API Key to the function 
or set the environmental variable: \code{VirustotalToken}. Environment variables persist within 
a R session.
}
\examples{
\dontrun{
virustotal_cat("http://www.google.com")
}
}
\references{
\url{https://www.virustotal.com/en/documentation/public-api/}
}
