% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_key.R
\name{dpla_get_key}
\alias{dpla_get_key}
\title{Request an API key from the Digital Public Library of America (DPLA).}
\usage{
dpla_get_key(email, ...)
}
\arguments{
\item{email}{(character) An email address.}

\item{...}{Curl options passed on to \code{\link[httr]{POST}}, eg.,
\code{\link[httr]{verbose}}}
}
\value{
On success, a message that your API key will be emailed
to you.
}
\description{
Request an API key from the Digital Public Library of America (DPLA).
}
\details{
You are required to have an API key to use \pkg{rdpla}. To get one,
use \code{dpla_get_key} for getting a key programatically.
After getting the key, you can pass the key as a parameter to \pkg{rdpla}
functions, but we recommend storing the key on your machine, since not
exposing your key in your files that may end up on the web is good
practice. Store your key either as an environment variable in your
\code{.Renviron} file or similar like \code{DPLA_API_KEY=<yourkey>},
or as an R option in your \code{.Rprofile} file like
\code{options(dpla_api_key = "<yourkey>")}. Either will be read in
when you call \pkg{rdpla} functions. Make sure to restart your R session
after storing your key as either env var or R option.
}
\examples{
\dontrun{
# dpla_get_key(email="stuff@thing.com")
}
}

