% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileDWD.R
\name{fileDWD}
\alias{fileDWD}
\title{file management for rdwd}
\usage{
fileDWD(filename, quiet = FALSE, ntrunc = 3, ignore = FALSE)
}
\arguments{
\item{filename}{Char (vector): file name(s).}

\item{quiet}{Logical (vector): Suppress messages about creating file(s)? DEFAULT: FALSE}

\item{ntrunc}{Integer: Number of filenames printed in messages before they
get truncated with message "(and xx more)". DEFAULT: 3}

\item{ignore}{Logical (vector): Ignore file? Handy in dataDWD. DEFAULT: FALSE}
}
\value{
fileDWD returns the input with an added "_n" in the filename if the
        file already existed.
}
\description{
Manage files in the rdwd package.
Files are never overwritten but saved with a message as OriginalName_1.file
or OriginalName_2.file etc.
}
\examples{
# see source code of dataDWD and metaDWD

fns <- c("data", "stupiddummy", "ExampleGraph.png", "rdwd.Rproj", "README.md",
         "stupiddummy.txtdude", "DESCRIPTION", "test_devel.R")
fileDWD(fns)
fileDWD(fns, ignore=TRUE)
fileDWD(fns, ignore=rep(0:1, each=4))
fileDWD(fns, ntrunc=2)
fileDWD("ExampleGraph.png")

}
\seealso{
\code{\link{dirDWD}}, \code{\link{dataDWD}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct 2016
}
\keyword{file}
