% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLocalTests.R
\name{runLocalTests}
\alias{runLocalTests}
\title{run local tests of rdwd}
\usage{
runLocalTests(dir_data = localtestdir(),
  dir_exmpl = localtestdir(folder = "misc/ExampleTests"), fast = FALSE,
  radar = !fast, all_Potsdam_files = !fast, examples = !fast,
  quiet = FALSE)
}
\arguments{
\item{dir_data}{Reusable data location. Preferably not under version control.
DEFAULT: \code{\link{localtestdir}()}}

\item{dir_exmpl}{Reusable example location. DEFAULT: localtestdir(folder="misc/ExampleTests")}

\item{fast}{Exclude many tests? DEFAULT: FALSE}

\item{radar}{Test reading radar example files. DEFAULT: !fast}

\item{all_Potsdam_files}{Read all (ca 60) files for Potsdam? Re-downloads if
files are older than 24 hours. Reduce test time a lot by setting
this to FALSE. DEFAULT: !fast}

\item{examples}{Run Examples (including donttest sections) DEFAULT: !fast}

\item{quiet}{Suppress progress messages? DEFAULT: FALSE}
}
\value{
Time taken to run tests in minutes
}
\description{
Run \code{rdwd} tests on local machine. Due to time-intensive 
data downloads, these tests are not run automatically on CRAN.
}
\seealso{
\code{\link{localtestdir}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr-Oct 2019
}
\keyword{debugging}
