% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotCSM}
\alias{plotCSM}
\title{Produce Cumulative Sample Mean Function Plots}
\usage{
plotCSM(formula, data, onePanel = FALSE, adjrisk = TRUE,
  control = list(), ...)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a "~" operator, and the predictors on the right.
The response must be a recurrent event survival object as returned by function \code{reSurv}.}

\item{data}{an optional data frame in which to interpret the variables occurring in the "\code{formula}".}

\item{onePanel}{an optional logical value indicating whether cumulative sample means (CSM) will be plotted in the same panel.
This is useful when comparing CSM from different groups.}

\item{adjrisk}{an optional logical value indicating whether risk set will be adjusted. See \bold{Details}.}

\item{control}{a list of control parameters.}

\item{...}{graphical parameters to be passed to methods.
These include \code{xlab}, \code{ylab} and \code{main}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the cumulative sample mean function (CSM) for an \code{reSurv} object.
The function is similar to \code{plot.reSurv} but with more flexible options.
}
\details{
When \code{adjrisk = TRUE}, the \code{plotCSM} is equivalent to
the Nelson-Aalen estimator for the intensity function of the recurrent event process.
When \code{adjrisk = FALSE}, the \code{plotCSM} does not adjust for the risk set and
assumes all subjects remain at risk after the last observed recurrent event.
This is known as the survivor rate function.
The argument \code{control} consists of options with argument defaults
to a list with the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is "Cumulative mean".}
  \item{main}{customizable title, default value is "Sample cumulative mean function plot".}
}
The \code{xlab}, \code{ylab} and \code{main} parameters can also be passed down without specifying a \code{control} list.
}
\examples{
data(readmission, package = "frailtypack")
plotCSM(reSurv(t.stop, id, event, death) ~ 1, data = readmission)
plotCSM(reSurv(t.stop, id, event, death) ~ sex, data = readmission)
plotCSM(reSurv(t.stop, id, event, death) ~ sex, data = readmission, onePanel = TRUE)
}
\seealso{
\code{\link{reSurv}}, \code{\link{plot.reSurv}}
}
\keyword{Plots}
