% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.R
\name{simGSC}
\alias{simGSC}
\title{Function to generate simulated recurrent event data}
\usage{
simGSC(
  n,
  summary = FALSE,
  para,
  xmat,
  censoring,
  frailty,
  tau,
  origin,
  Lam0,
  Haz0
)
}
\arguments{
\item{n}{number of observation.}

\item{summary}{a logical value indicating whether a brief data summary will be printed.}

\item{para}{a list of numerical vectors for the regression coefficients
in the joint scale-change model. 
The names of the list elements are \code{alpha}, \code{beta}, \code{eta}, and
\code{theta}, correspond to \eqn{\alpha}, \eqn{\beta}, \eqn{\eta}, and \eqn{\theta}
in the joint scale-change model, respectively.
See \bold{Details} for \code{\link{reReg}}.}

\item{xmat}{an optional matrix specifying the design matrix.}

\item{censoring}{a numeric variable specifying the censoring times for each of the
\eqn{n} observation.}

\item{frailty}{a numeric variable specifying the frailty variable.}

\item{tau}{a numeric value specifying the maximum observation time.}

\item{origin}{a numeric value specifying the time origin.}

\item{Lam0}{is an optional function that specifies the baseline cumulative rate function.
When left-unspecified, the recurrent events are generated using the
baseline rate function of \deqn{\lambda_0(t) = \frac{2}{1 + t},} or equivalently,
the cumulative rate function of \deqn{\Lambda_0(t) = 2\log(1 + t).}}

\item{Haz0}{is an optional function that specifies the baseline hazard function.
When left-unspecified, the recurrent events are generated using the baseline hazard function
\deqn{h_0(t) = \frac{1}{5(1 + t)},} or equivalently,
the cumulative hazard function of \deqn{H_0(t) = \log(1 + t) / 5.}}
}
\description{
The function \code{simGSC()} generates simulated recurrent event data from either
a Cox-type model, an accelerated mean model, an accelerated rate model, or a generalized scale-change model.
}
\details{
The function \code{simGSC()} generates simulated recurrent event data over
the interval \eqn{(0, \tau)} based on the specification of the recurrent process and
the terminal events.
Specifically, the rate function, \eqn{\lambda(t)}, of the recurrent process
can be specified as one of the following model:
\deqn{\lambda(t) = Z \lambda_0(te^{X^\top\alpha}) e^{X^\top\beta}, h(t) = Z h_0(te^{X^\top\eta})e^{X^\top\theta}, }
where \eqn{\lambda_0(t)} is the baseline rate function,
\eqn{h_0(t)} is the baseline hazard function,
\eqn{X} is a \eqn{n} by \eqn{p} covariate matrix and \eqn{\alpha},
\eqn{Z} is an unobserved shared frailty variable, and
\eqn{(\alpha, \eta)} and \eqn{(\beta, \theta)} correspond to the shape and size parameters of the
rate function and the hazard function, respectively.

Under the default settings, the \code{simGSC()} function assumes \eqn{p = 2}
and the regression parameters to be \eqn{\alpha = \eta = (0, 0)^\top},
and \eqn{\beta = \theta = (1, 1)^\top}.
When the \code{xmat} argument is not specified, the \code{simGSC()} function
assumes \eqn{X_i} is a two-dimensional vector \eqn{X_i = (X_{i1}, X_{i2}), i = 1, \ldots, n},
where \eqn{X_{i1}} is a Bernoulli variable with rate 0.5 and
\eqn{X_{i2}} is a standard normal variable.
With the default \code{xmat}, the censoring time $C$ is generated from
an exponential distribution with mean \eqn{\tau X_{i1} + Z^2\tau(1 - X_{i1})}.
Thus, the censoring distribution is covariate dependent and
is informative when \eqn{Z} is not a constant.
When the \code{frailty} argument is not specified, the frailty variable \eqn{Z} is generated
from a gamma distribution with a unit mean and a variance of 0.25.
The default values for \code{tau} and \code{origin} are 60 and 0, respectively.
When arguments \code{Lam0} and \code{Haz0} are left unspecified,
the \code{simGSC()} function uses \eqn{\Lambda_0(t) = 2\log(1 + t)}
and \eqn{H_0(t) = \log(1 + t) / 5}, respectively.
This is equivalent to setting
\code{Lam0 = function(x) 2 * log(1 + x)} and \code{Haz0 = function(x) log(1 + x) / 5}.
Overall, the default specifications generate the recurrent events and the terminal events
from the model:
\deqn{\lambda(t) = \displaystyle \frac{2Z}{1 + te^{-X_{i1} - X_{i2}}},
h(t) = \displaystyle \frac{Z}{5(1 + te^{X_{i1} + X_{i2}})},  t\in[0, 60].}
See \href{https://www.sychiou.com/reReg/articles/reReg-sims.html}{online vignette}
for more examples.
}
\examples{
set.seed(123)
simGSC(100, summary = TRUE)
}
\seealso{
\code{\link{reReg}}
}
