% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{minty}
\alias{minty}
\title{Theme minty}
\usage{
minty(
  font_family = "Helvetica",
  font_size = 15,
  font_color = "#9a9a9a",
  header_font_family = "Helvetica",
  header_font_size = 16,
  header_font_color = "#c9e7de",
  cell_padding = 6
)
}
\arguments{
\item{font_family}{Font family for the text within the table.
Default is Helvetica.}

\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #9a9a9a.}

\item{header_font_family}{Font family for the header text.
Default is Helvetica.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 16.}

\item{header_font_color}{Color of the font for the header text.
Default is #c9e7de.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
Bootstrap-inspired minty theme
}
\examples{
data <- iris[10:29, ]

## Standard minty theme
reactable(data,
          theme = minty())

## Cerulean theme with additional options applied
reactable(data,
          theme = minty(font_size = 12, font_color = "grey", cell_padding = 3))

}
